/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.group.internals;

import com.ctrip.framework.apollo.tracer.Tracer;
import com.digiwin.apollo.group.exceptions.ApolloConfigException;
import com.digiwin.apollo.group.internals.ConfigManager;
import com.digiwin.apollo.group.internals.ConfigServiceLocator;
import com.digiwin.apollo.group.internals.DefaultConfigManager;
import com.digiwin.apollo.group.internals.Injector;
import com.digiwin.apollo.group.internals.RemoteConfigLongPollService;
import com.digiwin.apollo.group.spi.ConfigFactory;
import com.digiwin.apollo.group.spi.ConfigFactoryManager;
import com.digiwin.apollo.group.spi.ConfigRegistry;
import com.digiwin.apollo.group.spi.DefaultConfigFactory;
import com.digiwin.apollo.group.spi.DefaultConfigFactoryManager;
import com.digiwin.apollo.group.spi.DefaultConfigRegistry;
import com.digiwin.apollo.group.util.ConfigUtil;
import com.digiwin.apollo.group.util.factory.DefaultPropertiesFactory;
import com.digiwin.apollo.group.util.factory.PropertiesFactory;
import com.digiwin.apollo.group.util.http.HttpUtil;
import com.digiwin.apollo.group.util.yaml.YamlParser;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Singleton;

public class DefaultInjector
implements Injector {
    private com.google.inject.Injector m_injector;

    public DefaultInjector() {
        try {
            this.m_injector = Guice.createInjector((Module[])new Module[]{new ApolloModule()});
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException("Unable to initialize Guice Injector!", ex);
            Tracer.logError(exception);
            throw exception;
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz) {
        try {
            return (T)this.m_injector.getInstance(clazz);
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            throw new ApolloConfigException(String.format("Unable to load instance for %s!", clazz.getName()), ex);
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz, String name) {
        return null;
    }

    private static class ApolloModule
    extends AbstractModule {
        private ApolloModule() {
        }

        protected void configure() {
            this.bind(ConfigManager.class).to(DefaultConfigManager.class).in(Singleton.class);
            this.bind(ConfigFactoryManager.class).to(DefaultConfigFactoryManager.class).in(Singleton.class);
            this.bind(ConfigRegistry.class).to(DefaultConfigRegistry.class).in(Singleton.class);
            this.bind(ConfigFactory.class).to(DefaultConfigFactory.class).in(Singleton.class);
            this.bind(ConfigUtil.class).in(Singleton.class);
            this.bind(HttpUtil.class).in(Singleton.class);
            this.bind(ConfigServiceLocator.class).in(Singleton.class);
            this.bind(RemoteConfigLongPollService.class).in(Singleton.class);
            this.bind(YamlParser.class).in(Singleton.class);
            this.bind(PropertiesFactory.class).to(DefaultPropertiesFactory.class).in(Singleton.class);
        }
    }
}

