/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.group.util.parser;

import com.digiwin.apollo.group.util.parser.ParserException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parsers {
    public static DateParser forDate() {
        return DateParser.INSTANCE;
    }

    public static DurationParser forDuration() {
        return DurationParser.INSTANCE;
    }

    public static enum DurationParser {
        INSTANCE;

        private static final Pattern PATTERN;
        private static final int HOURS_PER_DAY = 24;
        private static final int MINUTES_PER_HOUR = 60;
        private static final int SECONDS_PER_MINUTE = 60;
        private static final int MILLIS_PER_SECOND = 1000;
        private static final int MILLIS_PER_MINUTE = 60000;
        private static final int MILLIS_PER_HOUR = 3600000;
        private static final int MILLIS_PER_DAY = 86400000;

        public long parseToMillis(String text) throws ParserException {
            Matcher matcher = PATTERN.matcher(text);
            if (matcher.matches()) {
                String dayMatch = matcher.group(1);
                String hourMatch = matcher.group(2);
                String minuteMatch = matcher.group(3);
                String secondMatch = matcher.group(4);
                String fractionMatch = matcher.group(5);
                if (dayMatch != null || hourMatch != null || minuteMatch != null || secondMatch != null || fractionMatch != null) {
                    int daysAsMilliSecs = DurationParser.parseNumber(dayMatch, 86400000);
                    int hoursAsMilliSecs = DurationParser.parseNumber(hourMatch, 3600000);
                    int minutesAsMilliSecs = DurationParser.parseNumber(minuteMatch, 60000);
                    int secondsAsMilliSecs = DurationParser.parseNumber(secondMatch, 1000);
                    int milliseconds = DurationParser.parseNumber(fractionMatch, 1);
                    return daysAsMilliSecs + hoursAsMilliSecs + minutesAsMilliSecs + secondsAsMilliSecs + milliseconds;
                }
            }
            throw new ParserException(String.format("Text %s cannot be parsed to duration)", text));
        }

        private static int parseNumber(String parsed, int multiplier) {
            if (parsed == null || parsed.trim().isEmpty()) {
                return 0;
            }
            return Integer.parseInt(parsed) * multiplier;
        }

        static {
            PATTERN = Pattern.compile("(?:([0-9]+)D)?(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+)S)?(?:([0-9]+)(?:MS)?)?", 2);
        }
    }

    public static enum DateParser {
        INSTANCE;

        private static final String LONG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        private static final String MEDIUM_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        private static final String SHORT_DATE_FORMAT = "yyyy-MM-dd";

        public Date parse(String text) throws ParserException {
            int length = (text = text.trim()).length();
            if (length == LONG_DATE_FORMAT.length()) {
                return this.parse(text, LONG_DATE_FORMAT);
            }
            if (length == MEDIUM_DATE_FORMAT.length()) {
                return this.parse(text, MEDIUM_DATE_FORMAT);
            }
            return this.parse(text, SHORT_DATE_FORMAT);
        }

        public Date parse(String text, String format) throws ParserException {
            return this.parse(text, format, Locale.US);
        }

        public Date parse(String text, String format, Locale locale) throws ParserException {
            SimpleDateFormat dateFormat = this.getDateFormat(format, locale);
            try {
                return dateFormat.parse(text.trim());
            }
            catch (ParseException e) {
                throw new ParserException("Error when parsing date(" + dateFormat.toPattern() + ") from " + text, e);
            }
        }

        private SimpleDateFormat getDateFormat(String format, Locale locale) {
            return new SimpleDateFormat(format, locale);
        }
    }
}

