/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.spring.annotation;

import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.spring.annotation.ApolloProcessor;
import com.digiwin.apollo.application.spring.property.PlaceholderHelper;
import com.digiwin.apollo.application.spring.property.SpringValue;
import com.digiwin.apollo.application.spring.property.SpringValueDefinition;
import com.digiwin.apollo.application.spring.property.SpringValueDefinitionProcessor;
import com.digiwin.apollo.application.spring.property.SpringValueRegistry;
import com.digiwin.apollo.application.spring.util.SpringInjector;
import com.digiwin.apollo.application.util.ConfigUtil;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;

public class SpringValueProcessor
extends ApolloProcessor
implements BeanFactoryPostProcessor,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(SpringValueProcessor.class);
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
    private final SpringValueRegistry springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
    private BeanFactory beanFactory;
    private Multimap<String, SpringValueDefinition> beanName2SpringValueDefinitions = LinkedListMultimap.create();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled() && beanFactory instanceof BeanDefinitionRegistry) {
            this.beanName2SpringValueDefinitions = SpringValueDefinitionProcessor.getBeanName2SpringValueDefinitions((BeanDefinitionRegistry)beanFactory);
        }
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            super.postProcessBeforeInitialization(bean, beanName);
            this.processBeanPropertyValues(bean, beanName);
        }
        return bean;
    }

    @Override
    protected void processField(Object bean, String beanName, Field field) {
        Value value = field.getAnnotation(Value.class);
        if (value == null) {
            return;
        }
        Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(value.value());
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            SpringValue springValue = new SpringValue(key, value.value(), bean, beanName, field, false);
            this.springValueRegistry.register(this.beanFactory, key, springValue);
            logger.debug((Object)("Monitoring " + springValue));
        }
    }

    @Override
    protected void processMethod(Object bean, String beanName, Method method) {
        Value value = method.getAnnotation(Value.class);
        if (value == null) {
            return;
        }
        if (method.getAnnotation(Bean.class) != null) {
            return;
        }
        if (method.getParameterTypes().length != 1) {
            logger.error((Object)("Ignore @Value setter " + bean.getClass().getName() + "." + method.getName() + ", expecting 1 parameter, actual " + method.getParameterTypes().length + " parameters"));
            return;
        }
        Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(value.value());
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            SpringValue springValue = new SpringValue(key, value.value(), bean, beanName, method, false);
            this.springValueRegistry.register(this.beanFactory, key, springValue);
            logger.info((Object)("Monitoring " + springValue));
        }
    }

    private void processBeanPropertyValues(Object bean, String beanName) {
        Collection propertySpringValues = this.beanName2SpringValueDefinitions.get((Object)beanName);
        if (propertySpringValues == null || propertySpringValues.isEmpty()) {
            return;
        }
        for (SpringValueDefinition definition : propertySpringValues) {
            try {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)definition.getPropertyName());
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                SpringValue springValue = new SpringValue(definition.getKey(), definition.getPlaceholder(), bean, beanName, method, false);
                this.springValueRegistry.register(this.beanFactory, definition.getKey(), springValue);
                logger.debug((Object)("Monitoring " + springValue));
            }
            catch (Throwable ex) {
                logger.error((Object)("Failed to enable auto update feature for " + bean.getClass() + "." + definition.getPropertyName()));
            }
        }
        this.beanName2SpringValueDefinitions.removeAll((Object)beanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

