/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.ctrip.framework.apollo.core.dto.ApolloConfigNotification;
import com.ctrip.framework.apollo.core.dto.ApolloNotificationMessages;
import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.schedule.ExponentialSchedulePolicy;
import com.ctrip.framework.apollo.core.schedule.SchedulePolicy;
import com.ctrip.framework.apollo.core.signature.Signature;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.exceptions.ApolloConfigException;
import com.digiwin.apollo.application.internals.ConfigServiceLocator;
import com.digiwin.apollo.application.internals.RemoteConfigRepository;
import com.digiwin.apollo.application.util.ConfigUtil;
import com.digiwin.apollo.application.util.ExceptionUtil;
import com.digiwin.apollo.application.util.http.HttpRequest;
import com.digiwin.apollo.application.util.http.HttpResponse;
import com.digiwin.apollo.application.util.http.HttpUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteConfigLongPollService {
    private static final Log logger = LogFactory.getLog(RemoteConfigLongPollService.class);
    private static final Joiner STRING_JOINER = Joiner.on((String)"+");
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    private static final Escaper queryParamEscaper = UrlEscapers.urlFormParameterEscaper();
    private static final long INIT_NOTIFICATION_ID = -1L;
    private static final int LONG_POLLING_READ_TIMEOUT = 90000;
    private final ExecutorService m_longPollingService;
    private final AtomicBoolean m_longPollingStopped;
    private SchedulePolicy m_longPollFailSchedulePolicyInSecond = new ExponentialSchedulePolicy(1L, 120L);
    private RateLimiter m_longPollRateLimiter;
    private final AtomicBoolean m_longPollStarted;
    private final Multimap<String, RemoteConfigRepository> m_longPollNamespaces;
    private final ConcurrentMap<String, Long> m_notifications;
    private final Map<String, ApolloNotificationMessages> m_remoteNotificationMessages;
    private Type m_responseType;
    private static final Gson GSON = new Gson();
    private ConfigUtil m_configUtil;
    private HttpUtil m_httpUtil;
    private ConfigServiceLocator m_serviceLocator;

    public RemoteConfigLongPollService() {
        this.m_longPollingStopped = new AtomicBoolean(false);
        this.m_longPollingService = Executors.newSingleThreadExecutor(ApolloThreadFactory.create("RemoteConfigLongPollService", true));
        this.m_longPollStarted = new AtomicBoolean(false);
        this.m_longPollNamespaces = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        this.m_notifications = Maps.newConcurrentMap();
        this.m_remoteNotificationMessages = Maps.newConcurrentMap();
        this.m_responseType = new TypeToken<List<ApolloConfigNotification>>(){}.getType();
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.m_httpUtil = ApolloInjector.getInstance(HttpUtil.class);
        this.m_serviceLocator = ApolloInjector.getInstance(ConfigServiceLocator.class);
        this.m_longPollRateLimiter = RateLimiter.create((double)this.m_configUtil.getLongPollQPS());
    }

    public boolean submit(String namespace, RemoteConfigRepository remoteConfigRepository) {
        boolean added = this.m_longPollNamespaces.put((Object)namespace, (Object)remoteConfigRepository);
        this.m_notifications.putIfAbsent(namespace, -1L);
        if (!this.m_longPollStarted.get()) {
            this.startLongPolling();
        }
        return added;
    }

    private void startLongPolling() {
        if (!this.m_longPollStarted.compareAndSet(false, true)) {
            return;
        }
        try {
            final String appId = this.m_configUtil.getAppId();
            final String cluster = this.m_configUtil.getCluster();
            final String dataCenter = this.m_configUtil.getDataCenter();
            final String secret = this.m_configUtil.getAccessKeySecret();
            final long longPollingInitialDelayInMills = this.m_configUtil.getLongPollingInitialDelayInMills();
            this.m_longPollingService.submit(new Runnable(){

                @Override
                public void run() {
                    if (longPollingInitialDelayInMills > 0L) {
                        try {
                            logger.debug((Object)("Long polling will start in " + longPollingInitialDelayInMills + " ms."));
                            TimeUnit.MILLISECONDS.sleep(longPollingInitialDelayInMills);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RemoteConfigLongPollService.this.doLongPollingRefresh(appId, cluster, dataCenter, secret);
                }
            });
        }
        catch (Throwable ex) {
            this.m_longPollStarted.set(false);
            ApolloConfigException exception = new ApolloConfigException("Schedule long polling refresh failed", ex);
            Tracer.logError(exception);
            logger.warn((Object)ExceptionUtil.getDetailMessage(exception));
        }
    }

    void stopLongPollingRefresh() {
        this.m_longPollingStopped.compareAndSet(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLongPollingRefresh(String appId, String cluster, String dataCenter, String secret) {
        Random random = new Random();
        ServiceDTO lastServiceDto = null;
        while (!this.m_longPollingStopped.get() && !Thread.currentThread().isInterrupted()) {
            if (!this.m_longPollRateLimiter.tryAcquire(5L, TimeUnit.SECONDS)) {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Transaction transaction = Tracer.newTransaction("Apollo.ConfigService", "pollNotification");
            String url = null;
            try {
                if (lastServiceDto == null) {
                    List<ServiceDTO> configServices = this.getConfigServices();
                    lastServiceDto = configServices.get(random.nextInt(configServices.size()));
                }
                url = this.assembleLongPollRefreshUrl(lastServiceDto.getHomepageUrl(), appId, cluster, dataCenter, this.m_notifications);
                logger.debug((Object)("Long polling from " + url));
                HttpRequest request = new HttpRequest(url);
                request.setReadTimeout(90000);
                if (!StringUtils.isBlank(secret)) {
                    Map<String, String> headers = Signature.buildHttpHeaders(url, appId, secret);
                    request.setHeaders(headers);
                }
                transaction.addData("Url", url);
                HttpResponse response = this.m_httpUtil.doGet(request, this.m_responseType);
                logger.debug((Object)("Long polling response: " + response.getStatusCode() + ", url: " + url));
                if (response.getStatusCode() == 200 && response.getBody() != null) {
                    this.updateNotifications((List)response.getBody());
                    this.updateRemoteNotifications((List)response.getBody());
                    transaction.addData("Result", ((List)response.getBody()).toString());
                    this.notify(lastServiceDto, (List)response.getBody());
                }
                if (response.getStatusCode() == 304 && random.nextBoolean()) {
                    lastServiceDto = null;
                }
                this.m_longPollFailSchedulePolicyInSecond.success();
                transaction.addData("StatusCode", response.getStatusCode());
                transaction.setStatus("0");
            }
            catch (Throwable ex) {
                lastServiceDto = null;
                Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
                transaction.setStatus(ex);
                long sleepTimeInSecond = this.m_longPollFailSchedulePolicyInSecond.fail();
                logger.debug((Object)("Long polling failed, will retry in " + sleepTimeInSecond + " seconds. appId: " + appId + ", cluster: " + cluster + ", namespaces: " + this.assembleNamespaces() + ", long polling url: " + url + ", reason: " + ExceptionUtil.getDetailMessage(ex)));
                try {
                    TimeUnit.SECONDS.sleep(sleepTimeInSecond);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                transaction.complete();
            }
        }
    }

    private void notify(ServiceDTO lastServiceDto, List<ApolloConfigNotification> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            return;
        }
        for (ApolloConfigNotification notification : notifications) {
            String namespaceName = notification.getNamespaceName();
            ArrayList toBeNotified = Lists.newArrayList((Iterable)this.m_longPollNamespaces.get((Object)namespaceName));
            ApolloNotificationMessages originalMessages = this.m_remoteNotificationMessages.get(namespaceName);
            ApolloNotificationMessages remoteMessages = originalMessages == null ? null : originalMessages.clone();
            toBeNotified.addAll(this.m_longPollNamespaces.get((Object)String.format("%s.%s", namespaceName, ConfigFileFormat.Properties.getValue())));
            for (RemoteConfigRepository remoteConfigRepository : toBeNotified) {
                try {
                    remoteConfigRepository.onLongPollNotified(lastServiceDto, remoteMessages);
                }
                catch (Throwable ex) {
                    Tracer.logError(ex);
                }
            }
        }
    }

    private void updateNotifications(List<ApolloConfigNotification> deltaNotifications) {
        for (ApolloConfigNotification notification : deltaNotifications) {
            String namespaceNameWithPropertiesSuffix;
            if (Strings.isNullOrEmpty((String)notification.getNamespaceName())) continue;
            String namespaceName = notification.getNamespaceName();
            if (this.m_notifications.containsKey(namespaceName)) {
                this.m_notifications.put(namespaceName, notification.getNotificationId());
            }
            if (!this.m_notifications.containsKey(namespaceNameWithPropertiesSuffix = String.format("%s.%s", namespaceName, ConfigFileFormat.Properties.getValue()))) continue;
            this.m_notifications.put(namespaceNameWithPropertiesSuffix, notification.getNotificationId());
        }
    }

    private void updateRemoteNotifications(List<ApolloConfigNotification> deltaNotifications) {
        for (ApolloConfigNotification notification : deltaNotifications) {
            if (Strings.isNullOrEmpty((String)notification.getNamespaceName()) || notification.getMessages() == null || notification.getMessages().isEmpty()) continue;
            ApolloNotificationMessages localRemoteMessages = this.m_remoteNotificationMessages.get(notification.getNamespaceName());
            if (localRemoteMessages == null) {
                localRemoteMessages = new ApolloNotificationMessages();
                this.m_remoteNotificationMessages.put(notification.getNamespaceName(), localRemoteMessages);
            }
            localRemoteMessages.mergeFrom(notification.getMessages());
        }
    }

    private String assembleNamespaces() {
        return STRING_JOINER.join((Iterable)this.m_longPollNamespaces.keySet());
    }

    String assembleLongPollRefreshUrl(String uri, String appId, String cluster, String dataCenter, Map<String, Long> notificationsMap) {
        String localIp;
        HashMap queryParams = Maps.newHashMap();
        queryParams.put("appId", queryParamEscaper.escape(appId));
        queryParams.put("cluster", queryParamEscaper.escape(cluster));
        queryParams.put("notifications", queryParamEscaper.escape(this.assembleNotifications(notificationsMap)));
        if (!Strings.isNullOrEmpty((String)dataCenter)) {
            queryParams.put("dataCenter", queryParamEscaper.escape(dataCenter));
        }
        if (!Strings.isNullOrEmpty((String)(localIp = this.m_configUtil.getLocalIp()))) {
            queryParams.put("ip", queryParamEscaper.escape(localIp));
        }
        String params = MAP_JOINER.join((Map)queryParams);
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri + "notifications/v2?" + params;
    }

    String assembleNotifications(Map<String, Long> notificationsMap) {
        ArrayList notifications = Lists.newArrayList();
        for (Map.Entry<String, Long> entry : notificationsMap.entrySet()) {
            ApolloConfigNotification notification = new ApolloConfigNotification(entry.getKey(), entry.getValue());
            notifications.add(notification);
        }
        return GSON.toJson((Object)notifications);
    }

    private List<ServiceDTO> getConfigServices() {
        List<ServiceDTO> services = this.m_serviceLocator.getConfigServices();
        if (services.size() == 0) {
            throw new ApolloConfigException("No available config service");
        }
        return services;
    }
}

