/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.spring.spi;

import com.digiwin.apollo.application.spring.annotation.ApolloAnnotationProcessor;
import com.digiwin.apollo.application.spring.annotation.EnableApolloConfig;
import com.digiwin.apollo.application.spring.annotation.SpringValueProcessor;
import com.digiwin.apollo.application.spring.config.PropertySourcesProcessor;
import com.digiwin.apollo.application.spring.property.SpringValueDefinitionProcessor;
import com.digiwin.apollo.application.spring.spi.ApolloConfigRegistrarHelper;
import com.digiwin.apollo.application.spring.util.BeanRegistrationUtil;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DefaultApolloConfigRegistrarHelper
implements ApolloConfigRegistrarHelper {
    private Environment environment;

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableApolloConfig.class.getName()));
        String[] namespaces = attributes.getStringArray("value");
        int order = (Integer)attributes.getNumber("order");
        Object[] resolvedNamespaces = this.resolveNamespaces(namespaces);
        PropertySourcesProcessor.addNamespaces(Lists.newArrayList((Object[])resolvedNamespaces), order);
        HashMap<String, Object> propertySourcesPlaceholderPropertyValues = new HashMap<String, Object>();
        propertySourcesPlaceholderPropertyValues.put("order", 0);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesPlaceholderConfigurer.class.getName(), PropertySourcesPlaceholderConfigurer.class, propertySourcesPlaceholderPropertyValues);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesProcessor.class.getName(), PropertySourcesProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, ApolloAnnotationProcessor.class.getName(), ApolloAnnotationProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueProcessor.class.getName(), SpringValueProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueDefinitionProcessor.class.getName(), SpringValueDefinitionProcessor.class);
    }

    private String[] resolveNamespaces(String[] namespaces) {
        String[] resolvedNamespaces = new String[namespaces.length];
        for (int i = 0; i < namespaces.length; ++i) {
            resolvedNamespaces[i] = this.environment.resolveRequiredPlaceholders(namespaces[i]);
        }
        return resolvedNamespaces;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

