/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.spi.MetaServerProvider;
import com.ctrip.framework.foundation.Foundation;
import com.google.common.base.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMetaServerProvider
implements MetaServerProvider {
    public static final int ORDER = 0;
    private static final Log logger = LogFactory.getLog(DefaultMetaServerProvider.class);
    private final String metaServerAddress = this.initMetaServerAddress();

    private String initMetaServerAddress() {
        String metaAddress = System.getProperty("apollo.meta");
        if (Strings.isNullOrEmpty((String)metaAddress)) {
            metaAddress = System.getenv("APOLLO_META");
        }
        if (Strings.isNullOrEmpty((String)metaAddress)) {
            metaAddress = Foundation.server().getProperty("apollo.meta", null);
        }
        if (Strings.isNullOrEmpty((String)metaAddress)) {
            metaAddress = Foundation.app().getProperty("apollo.meta", null);
        }
        if (Strings.isNullOrEmpty((String)metaAddress)) {
            logger.warn((Object)"Could not find meta server address, because it is not available in neither (1) JVM system property 'apollo.meta', (2) OS env variable 'APOLLO_META' (3) property 'apollo.meta' from server.properties nor (4) property 'apollo.meta' from app.properties");
        } else {
            metaAddress = metaAddress.trim();
            logger.info((Object)("Located meta services from apollo.meta configuration: " + metaAddress + "!"));
        }
        return metaAddress;
    }

    @Override
    public String getMetaServerAddress(Env targetEnv) {
        return this.metaServerAddress;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

