/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.spring.annotation;

import com.digiwin.apollo.application.ApplicationConfig;
import com.digiwin.apollo.application.ApplicationConfigService;
import com.digiwin.apollo.application.ConfigChangeListener;
import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.model.ConfigChangeEvent;
import com.digiwin.apollo.application.spring.annotation.ApolloConfig;
import com.digiwin.apollo.application.spring.annotation.ApolloConfigChangeListener;
import com.digiwin.apollo.application.spring.annotation.ApolloJsonValue;
import com.digiwin.apollo.application.spring.annotation.ApolloProcessor;
import com.digiwin.apollo.application.spring.property.PlaceholderHelper;
import com.digiwin.apollo.application.spring.property.SpringValue;
import com.digiwin.apollo.application.spring.property.SpringValueRegistry;
import com.digiwin.apollo.application.spring.util.SpringInjector;
import com.digiwin.apollo.application.util.ConfigUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public class ApolloAnnotationProcessor
extends ApolloProcessor
implements BeanFactoryAware,
EnvironmentAware {
    private static final Log logger = LogFactory.getLog(ApolloAnnotationProcessor.class);
    private static final Gson GSON = new Gson();
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
    private final SpringValueRegistry springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
    private ConfigurableBeanFactory configurableBeanFactory;
    private Environment environment;

    @Override
    protected void processField(Object bean, String beanName, Field field) {
        this.processApolloConfig(bean, field);
        this.processApolloJsonValue(bean, beanName, field);
    }

    @Override
    protected void processMethod(Object bean, String beanName, Method method) {
        this.processApolloConfigChangeListener(bean, method);
        this.processApolloJsonValue(bean, beanName, method);
    }

    private void processApolloConfig(Object bean, Field field) {
        ApolloConfig annotation = (ApolloConfig)AnnotationUtils.getAnnotation((AnnotatedElement)field, ApolloConfig.class);
        if (annotation == null) {
            return;
        }
        Preconditions.checkArgument((boolean)ApplicationConfig.class.isAssignableFrom(field.getType()), (String)"Invalid type: %s for field: %s, should be Config", field.getType(), (Object)field);
        String namespace = annotation.value();
        String resolvedNamespace = this.environment.resolveRequiredPlaceholders(namespace);
        ApplicationConfig config = ApplicationConfigService.getConfig(resolvedNamespace);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)bean, (Object)config);
    }

    private void processApolloConfigChangeListener(final Object bean, final Method method) {
        ApolloConfigChangeListener annotation = (ApolloConfigChangeListener)AnnotationUtils.findAnnotation((Method)method, ApolloConfigChangeListener.class);
        if (annotation == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters: %s for method: %s, should be 1", (int)parameterTypes.length, (Object)method);
        Preconditions.checkArgument((boolean)ConfigChangeEvent.class.isAssignableFrom(parameterTypes[0]), (String)"Invalid parameter type: %s for method: %s, should be ConfigChangeEvent", parameterTypes[0], (Object)method);
        ReflectionUtils.makeAccessible((Method)method);
        String[] namespaces = annotation.value();
        Object[] annotatedInterestedKeys = annotation.interestedKeys();
        Object[] annotatedInterestedKeyPrefixes = annotation.interestedKeyPrefixes();
        ConfigChangeListener configChangeListener = new ConfigChangeListener(){

            @Override
            public void onChange(ConfigChangeEvent changeEvent) {
                ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{changeEvent});
            }
        };
        HashSet interestedKeys = annotatedInterestedKeys.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeys) : null;
        HashSet interestedKeyPrefixes = annotatedInterestedKeyPrefixes.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeyPrefixes) : null;
        for (String namespace : namespaces) {
            String resolvedNamespace = this.environment.resolveRequiredPlaceholders(namespace);
            ApplicationConfig config = ApplicationConfigService.getConfig(resolvedNamespace);
            if (interestedKeys == null && interestedKeyPrefixes == null) {
                config.addChangeListener(configChangeListener);
                continue;
            }
            config.addChangeListener(configChangeListener, interestedKeys, interestedKeyPrefixes);
        }
    }

    private void processApolloJsonValue(Object bean, String beanName, Field field) {
        ApolloJsonValue apolloJsonValue = (ApolloJsonValue)AnnotationUtils.getAnnotation((AnnotatedElement)field, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeholder = apolloJsonValue.value();
        Object propertyValue = this.placeholderHelper.resolvePropertyValue(this.configurableBeanFactory, beanName, placeholder);
        if (!(propertyValue instanceof String)) {
            return;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)bean, (Object)this.parseJsonValue((String)propertyValue, field.getGenericType()));
        field.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeholder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, placeholder, bean, beanName, field, true);
                this.springValueRegistry.register((BeanFactory)this.configurableBeanFactory, key, springValue);
                logger.debug((Object)("Monitoring " + springValue));
            }
        }
    }

    private void processApolloJsonValue(Object bean, String beanName, Method method) {
        ApolloJsonValue apolloJsonValue = (ApolloJsonValue)AnnotationUtils.getAnnotation((Method)method, ApolloJsonValue.class);
        if (apolloJsonValue == null) {
            return;
        }
        String placeHolder = apolloJsonValue.value();
        Object propertyValue = this.placeholderHelper.resolvePropertyValue(this.configurableBeanFactory, beanName, placeHolder);
        if (!(propertyValue instanceof String)) {
            return;
        }
        Type[] types = method.getGenericParameterTypes();
        Preconditions.checkArgument((types.length == 1 ? 1 : 0) != 0, (String)"Ignore @Value setter {}.{}, expecting 1 parameter, actual {} parameters", (Object)bean.getClass().getName(), (Object)method.getName(), (Object)method.getParameterTypes().length);
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{this.parseJsonValue((String)propertyValue, types[0])});
        method.setAccessible(accessible);
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(placeHolder);
            for (String key : keys) {
                SpringValue springValue = new SpringValue(key, apolloJsonValue.value(), bean, beanName, method, true);
                this.springValueRegistry.register((BeanFactory)this.configurableBeanFactory, key, springValue);
                logger.debug((Object)("Monitoring " + springValue));
            }
        }
    }

    private Object parseJsonValue(String json, Type targetType) {
        try {
            return GSON.fromJson(json, targetType);
        }
        catch (Throwable ex) {
            logger.error((Object)("Parsing json '" + json + "' to type " + targetType + " failed!"), ex);
            throw ex;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

