/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.digiwin.apollo.application.ApplicationConfig;
import com.digiwin.apollo.application.ConfigChangeListener;
import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.enums.ApplicationPropertyChangeType;
import com.digiwin.apollo.application.exceptions.ApolloConfigException;
import com.digiwin.apollo.application.model.ApplicationConfigChange;
import com.digiwin.apollo.application.model.ConfigChangeEvent;
import com.digiwin.apollo.application.util.ConfigUtil;
import com.digiwin.apollo.application.util.factory.PropertiesFactory;
import com.digiwin.apollo.application.util.function.Functions;
import com.digiwin.apollo.application.util.parser.Parsers;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConfig
implements ApplicationConfig {
    private static final Log logger = LogFactory.getLog(AbstractConfig.class);
    private static final ExecutorService m_executorService = Executors.newCachedThreadPool(ApolloThreadFactory.create("Config", true));
    private final List<ConfigChangeListener> m_listeners = Lists.newCopyOnWriteArrayList();
    private final Map<ConfigChangeListener, Set<String>> m_interestedKeys = Maps.newConcurrentMap();
    private final Map<ConfigChangeListener, Set<String>> m_interestedKeyPrefixes = Maps.newConcurrentMap();
    private final ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private volatile Cache<String, Integer> m_integerCache;
    private volatile Cache<String, Long> m_longCache;
    private volatile Cache<String, Short> m_shortCache;
    private volatile Cache<String, Float> m_floatCache;
    private volatile Cache<String, Double> m_doubleCache;
    private volatile Cache<String, Byte> m_byteCache;
    private volatile Cache<String, Boolean> m_booleanCache;
    private volatile Cache<String, Date> m_dateCache;
    private volatile Cache<String, Long> m_durationCache;
    private final Map<String, Cache<String, String[]>> m_arrayCache;
    private final List<Cache> allCaches;
    private final AtomicLong m_configVersion = new AtomicLong();
    protected PropertiesFactory propertiesFactory;

    public AbstractConfig() {
        this.m_arrayCache = Maps.newConcurrentMap();
        this.allCaches = Lists.newArrayList();
        this.propertiesFactory = ApolloInjector.getInstance(PropertiesFactory.class);
    }

    @Override
    public void addChangeListener(ConfigChangeListener listener) {
        this.addChangeListener(listener, null);
    }

    @Override
    public void addChangeListener(ConfigChangeListener listener, Set<String> interestedKeys) {
        this.addChangeListener(listener, interestedKeys, null);
    }

    @Override
    public void addChangeListener(ConfigChangeListener listener, Set<String> interestedKeys, Set<String> interestedKeyPrefixes) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
            if (interestedKeys != null && !interestedKeys.isEmpty()) {
                this.m_interestedKeys.put(listener, Sets.newHashSet(interestedKeys));
            }
            if (interestedKeyPrefixes != null && !interestedKeyPrefixes.isEmpty()) {
                this.m_interestedKeyPrefixes.put(listener, Sets.newHashSet(interestedKeyPrefixes));
            }
        }
    }

    @Override
    public boolean removeChangeListener(ConfigChangeListener listener) {
        this.m_interestedKeys.remove(listener);
        this.m_interestedKeyPrefixes.remove(listener);
        return this.m_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getIntProperty(String key, Integer defaultValue) {
        try {
            if (this.m_integerCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_integerCache == null) {
                        this.m_integerCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_INT_FUNCTION, this.m_integerCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getIntProperty for %s failed, return default value %d", key, defaultValue), ex));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLongProperty(String key, Long defaultValue) {
        try {
            if (this.m_longCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_longCache == null) {
                        this.m_longCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_LONG_FUNCTION, this.m_longCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getLongProperty for %s failed, return default value %d", key, defaultValue), ex));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short getShortProperty(String key, Short defaultValue) {
        try {
            if (this.m_shortCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_shortCache == null) {
                        this.m_shortCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_SHORT_FUNCTION, this.m_shortCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getShortProperty for %s failed, return default value %d", key, defaultValue), ex));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getFloatProperty(String key, Float defaultValue) {
        try {
            if (this.m_floatCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_floatCache == null) {
                        this.m_floatCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_FLOAT_FUNCTION, this.m_floatCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getFloatProperty for %s failed, return default value %f", key, defaultValue), ex));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getDoubleProperty(String key, Double defaultValue) {
        try {
            if (this.m_doubleCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_doubleCache == null) {
                        this.m_doubleCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_DOUBLE_FUNCTION, this.m_doubleCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getDoubleProperty for %s failed, return default value %f", key, defaultValue), ex));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte getByteProperty(String key, Byte defaultValue) {
        try {
            if (this.m_byteCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_byteCache == null) {
                        this.m_byteCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_BYTE_FUNCTION, this.m_byteCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getByteProperty for %s failed, return default value %d", key, defaultValue), ex));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        try {
            if (this.m_booleanCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_booleanCache == null) {
                        this.m_booleanCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_BOOLEAN_FUNCTION, this.m_booleanCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getBooleanProperty for %s failed, return default value %b", key, defaultValue), ex));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getArrayProperty(String key, final String delimiter, String[] defaultValue) {
        try {
            Cache<String, String[]> cache;
            String[] result;
            if (!this.m_arrayCache.containsKey(delimiter)) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (!this.m_arrayCache.containsKey(delimiter)) {
                        this.m_arrayCache.put(delimiter, this.newCache());
                    }
                }
            }
            if ((result = (String[])(cache = this.m_arrayCache.get(delimiter)).getIfPresent((Object)key)) != null) {
                return result;
            }
            return this.getValueAndStoreToCache(key, new Function<String, String[]>(){

                public String[] apply(String input) {
                    return input.split(delimiter);
                }
            }, cache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getArrayProperty for %s failed, return default value", key), ex));
            return defaultValue;
        }
    }

    @Override
    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumType, T defaultValue) {
        try {
            String value = this.getProperty(key, null);
            if (value != null) {
                return Enum.valueOf(enumType, value);
            }
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getEnumProperty for %s failed, return default value %s", key, defaultValue), ex));
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDateProperty(String key, Date defaultValue) {
        try {
            if (this.m_dateCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_dateCache == null) {
                        this.m_dateCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_DATE_FUNCTION, this.m_dateCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getDateProperty for %s failed, return default value %s", key, defaultValue), ex));
            return defaultValue;
        }
    }

    @Override
    public Date getDateProperty(String key, String format, Date defaultValue) {
        try {
            String value = this.getProperty(key, null);
            if (value != null) {
                return Parsers.forDate().parse(value, format);
            }
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getDateProperty for %s failed, return default value %s", key, defaultValue), ex));
        }
        return defaultValue;
    }

    @Override
    public Date getDateProperty(String key, String format, Locale locale, Date defaultValue) {
        try {
            String value = this.getProperty(key, null);
            if (value != null) {
                return Parsers.forDate().parse(value, format, locale);
            }
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getDateProperty for %s failed, return default value %s", key, defaultValue), ex));
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDurationProperty(String key, long defaultValue) {
        try {
            if (this.m_durationCache == null) {
                AbstractConfig abstractConfig = this;
                synchronized (abstractConfig) {
                    if (this.m_durationCache == null) {
                        this.m_durationCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, Functions.TO_DURATION_FUNCTION, this.m_durationCache, defaultValue);
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getDurationProperty for %s failed, return default value %d", key, defaultValue), ex));
            return defaultValue;
        }
    }

    @Override
    public <T> T getProperty(String key, Function<String, T> function, T defaultValue) {
        try {
            String value = this.getProperty(key, null);
            if (value != null) {
                return (T)function.apply((Object)value);
            }
        }
        catch (Throwable ex) {
            Tracer.logError(new ApolloConfigException(String.format("getProperty for %s failed, return default value %s", key, defaultValue), ex));
        }
        return defaultValue;
    }

    private <T> T getValueFromCache(String key, Function<String, T> parser, Cache<String, T> cache, T defaultValue) {
        Object result = cache.getIfPresent((Object)key);
        if (result != null) {
            return (T)result;
        }
        return this.getValueAndStoreToCache(key, parser, cache, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getValueAndStoreToCache(String key, Function<String, T> parser, Cache<String, T> cache, T defaultValue) {
        Object result;
        long currentConfigVersion = this.m_configVersion.get();
        String value = this.getProperty(key, null);
        if (value != null && (result = parser.apply((Object)value)) != null) {
            AbstractConfig abstractConfig = this;
            synchronized (abstractConfig) {
                if (this.m_configVersion.get() == currentConfigVersion) {
                    cache.put((Object)key, result);
                }
            }
            return (T)result;
        }
        return defaultValue;
    }

    private <T> Cache<String, T> newCache() {
        Cache cache = CacheBuilder.newBuilder().maximumSize(this.m_configUtil.getMaxConfigCacheSize()).expireAfterAccess(this.m_configUtil.getConfigCacheExpireTime(), this.m_configUtil.getConfigCacheExpireTimeUnit()).build();
        this.allCaches.add(cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearConfigCache() {
        AbstractConfig abstractConfig = this;
        synchronized (abstractConfig) {
            for (Cache c : this.allCaches) {
                if (c == null) continue;
                c.invalidateAll();
            }
            this.m_configVersion.incrementAndGet();
        }
    }

    protected void fireConfigChange(final ConfigChangeEvent changeEvent) {
        for (final ConfigChangeListener listener : this.m_listeners) {
            if (!this.isConfigChangeListenerInterested(listener, changeEvent)) continue;
            m_executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String listenerName = listener.getClass().getName();
                    Transaction transaction = Tracer.newTransaction("Apollo.ConfigChangeListener", listenerName);
                    try {
                        listener.onChange(changeEvent);
                        transaction.setStatus("0");
                    }
                    catch (Throwable ex) {
                        transaction.setStatus(ex);
                        Tracer.logError(ex);
                        logger.error((Object)("Failed to invoke config change listener " + listenerName), ex);
                    }
                    finally {
                        transaction.complete();
                    }
                }
            });
        }
    }

    private boolean isConfigChangeListenerInterested(ConfigChangeListener configChangeListener, ConfigChangeEvent configChangeEvent) {
        Set<String> interestedKeys = this.m_interestedKeys.get(configChangeListener);
        Set<String> interestedKeyPrefixes = this.m_interestedKeyPrefixes.get(configChangeListener);
        if ((interestedKeys == null || interestedKeys.isEmpty()) && (interestedKeyPrefixes == null || interestedKeyPrefixes.isEmpty())) {
            return true;
        }
        if (interestedKeys != null) {
            for (String interestedKey : interestedKeys) {
                if (!configChangeEvent.isChanged(interestedKey)) continue;
                return true;
            }
        }
        if (interestedKeyPrefixes != null) {
            for (String prefix : interestedKeyPrefixes) {
                for (String changedKey : configChangeEvent.changedKeys()) {
                    if (!changedKey.startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    List<ApplicationConfigChange> calcPropertyChanges(String namespace, Properties previous, Properties current) {
        if (previous == null) {
            previous = this.propertiesFactory.getPropertiesInstance();
        }
        if (current == null) {
            current = this.propertiesFactory.getPropertiesInstance();
        }
        Set<String> previousKeys = previous.stringPropertyNames();
        Set<String> currentKeys = current.stringPropertyNames();
        Sets.SetView commonKeys = Sets.intersection(previousKeys, currentKeys);
        Sets.SetView newKeys = Sets.difference(currentKeys, (Set)commonKeys);
        Sets.SetView removedKeys = Sets.difference(previousKeys, (Set)commonKeys);
        ArrayList changes = Lists.newArrayList();
        for (String newKey : newKeys) {
            changes.add(new ApplicationConfigChange(namespace, newKey, null, current.getProperty(newKey), ApplicationPropertyChangeType.ADDED));
        }
        for (String removedKey : removedKeys) {
            changes.add(new ApplicationConfigChange(namespace, removedKey, previous.getProperty(removedKey), null, ApplicationPropertyChangeType.DELETED));
        }
        for (String commonKey : commonKeys) {
            String currentValue;
            String previousValue = previous.getProperty(commonKey);
            if (Objects.equal((Object)previousValue, (Object)(currentValue = current.getProperty(commonKey)))) continue;
            changes.add(new ApplicationConfigChange(namespace, commonKey, previousValue, currentValue, ApplicationPropertyChangeType.MODIFIED));
        }
        return changes;
    }
}

