/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.Apollo;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.dto.ApolloConfig;
import com.ctrip.framework.apollo.core.dto.ApolloNotificationMessages;
import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.core.schedule.ExponentialSchedulePolicy;
import com.ctrip.framework.apollo.core.schedule.SchedulePolicy;
import com.ctrip.framework.apollo.core.signature.Signature;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.exceptions.ApolloConfigStatusCodeException;
import com.ctrip.framework.apollo.internals.AbstractConfigRepository;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.ConfigServiceLocator;
import com.ctrip.framework.apollo.internals.RemoteConfigLongPollService;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.ctrip.framework.apollo.util.http.HttpRequest;
import com.ctrip.framework.apollo.util.http.HttpResponse;
import com.ctrip.framework.apollo.util.http.HttpUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteConfigRepository
extends AbstractConfigRepository {
    private static final Log logger = LogFactory.getLog(RemoteConfigRepository.class);
    private static final Joiner STRING_JOINER = Joiner.on((String)"+");
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    private static final Escaper pathEscaper = UrlEscapers.urlPathSegmentEscaper();
    private static final Escaper queryParamEscaper = UrlEscapers.urlFormParameterEscaper();
    private final ConfigServiceLocator m_serviceLocator;
    private final HttpUtil m_httpUtil;
    private final ConfigUtil m_configUtil;
    private final RemoteConfigLongPollService remoteConfigLongPollService;
    private volatile AtomicReference<ApolloConfig> m_configCache;
    private final String m_namespace;
    private static final ScheduledExecutorService m_executorService;
    private final AtomicReference<ServiceDTO> m_longPollServiceDto;
    private final AtomicReference<ApolloNotificationMessages> m_remoteMessages;
    private final RateLimiter m_loadConfigRateLimiter;
    private final AtomicBoolean m_configNeedForceRefresh;
    private final SchedulePolicy m_loadConfigFailSchedulePolicy;
    private static final Gson GSON;

    public RemoteConfigRepository(String namespace) {
        this.m_namespace = namespace;
        this.m_configCache = new AtomicReference();
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.m_httpUtil = ApolloInjector.getInstance(HttpUtil.class);
        this.m_serviceLocator = ApolloInjector.getInstance(ConfigServiceLocator.class);
        this.remoteConfigLongPollService = ApolloInjector.getInstance(RemoteConfigLongPollService.class);
        this.m_longPollServiceDto = new AtomicReference();
        this.m_remoteMessages = new AtomicReference();
        this.m_loadConfigRateLimiter = RateLimiter.create((double)this.m_configUtil.getLoadConfigQPS());
        this.m_configNeedForceRefresh = new AtomicBoolean(true);
        this.m_loadConfigFailSchedulePolicy = new ExponentialSchedulePolicy(this.m_configUtil.getOnErrorRetryInterval(), this.m_configUtil.getOnErrorRetryInterval() * 8L);
        this.trySync();
        this.schedulePeriodicRefresh();
        this.scheduleLongPollingRefresh();
    }

    @Override
    public Properties getConfig() {
        if (this.m_configCache.get() == null) {
            this.sync();
        }
        return this.transformApolloConfigToProperties(this.m_configCache.get());
    }

    @Override
    public void setUpstreamRepository(ConfigRepository upstreamConfigRepository) {
    }

    @Override
    public ConfigSourceType getSourceType() {
        return ConfigSourceType.REMOTE;
    }

    private void schedulePeriodicRefresh() {
        logger.debug((Object)("Schedule periodic refresh with interval: " + this.m_configUtil.getRefreshInterval() + " " + (Object)((Object)this.m_configUtil.getRefreshIntervalTimeUnit())));
        m_executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Tracer.logEvent("Apollo.ConfigService", String.format("periodicRefresh: %s", RemoteConfigRepository.this.m_namespace));
                logger.debug((Object)("refresh config for namespace: " + RemoteConfigRepository.this.m_namespace));
                RemoteConfigRepository.this.trySync();
                Tracer.logEvent("Apollo.Client.Version", Apollo.VERSION);
            }
        }, this.m_configUtil.getRefreshInterval(), this.m_configUtil.getRefreshInterval(), this.m_configUtil.getRefreshIntervalTimeUnit());
    }

    @Override
    protected synchronized void sync() {
        Transaction transaction = Tracer.newTransaction("Apollo.ConfigService", "syncRemoteConfig");
        try {
            ApolloConfig previous = this.m_configCache.get();
            ApolloConfig current = this.loadApolloConfig();
            if (previous != current) {
                logger.debug((Object)"Remote Config refreshed!");
                this.m_configCache.set(current);
                this.fireRepositoryChange(this.m_namespace, this.getConfig());
            }
            if (current != null) {
                Tracer.logEvent(String.format("Apollo.Client.Configs.%s", current.getNamespaceName()), current.getReleaseKey());
            }
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            transaction.setStatus(ex);
            throw ex;
        }
        finally {
            transaction.complete();
        }
    }

    private Properties transformApolloConfigToProperties(ApolloConfig apolloConfig) {
        Properties result = this.propertiesFactory.getPropertiesInstance();
        result.putAll(apolloConfig.getConfigurations());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApolloConfig loadApolloConfig() {
        if (!this.m_loadConfigRateLimiter.tryAcquire(5L, TimeUnit.SECONDS)) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String appId = this.m_configUtil.getAppId();
        String cluster = this.m_configUtil.getCluster();
        String dataCenter = this.m_configUtil.getDataCenter();
        String secret = this.m_configUtil.getAccessKeySecret();
        Tracer.logEvent("Apollo.Client.ConfigMeta", STRING_JOINER.join((Object)appId, (Object)cluster, new Object[]{this.m_namespace}));
        int maxRetries = this.m_configNeedForceRefresh.get() ? 2 : 1;
        long onErrorSleepTime = 0L;
        Throwable exception = null;
        List<ServiceDTO> configServices = this.getConfigServices();
        String url = null;
        block13: for (int i = 0; i < maxRetries; ++i) {
            LinkedList randomConfigServices = Lists.newLinkedList(configServices);
            Collections.shuffle(randomConfigServices);
            if (this.m_longPollServiceDto.get() != null) {
                randomConfigServices.add(0, this.m_longPollServiceDto.getAndSet(null));
            }
            for (ServiceDTO configService : randomConfigServices) {
                if (onErrorSleepTime > 0L) {
                    logger.warn((Object)("Load config failed, will retry in " + onErrorSleepTime + " " + (Object)((Object)this.m_configUtil.getOnErrorRetryIntervalTimeUnit()) + ". appId: " + appId + ", cluster: " + cluster + ", namespaces: " + this.m_namespace));
                    try {
                        this.m_configUtil.getOnErrorRetryIntervalTimeUnit().sleep(onErrorSleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                url = this.assembleQueryConfigUrl(configService.getHomepageUrl(), appId, cluster, this.m_namespace, dataCenter, this.m_remoteMessages.get(), this.m_configCache.get());
                logger.debug((Object)("Loading config from " + url));
                HttpRequest request = new HttpRequest(url);
                if (!StringUtils.isBlank(secret)) {
                    Map<String, String> headers = Signature.buildHttpHeaders(url, appId, secret);
                    request.setHeaders(headers);
                }
                Transaction transaction = Tracer.newTransaction("Apollo.ConfigService", "queryConfig");
                transaction.addData("Url", url);
                try {
                    ApolloConfig notfoundConfig;
                    HttpResponse<ApolloConfig> response = this.m_httpUtil.doGet(request, ApolloConfig.class);
                    this.m_configNeedForceRefresh.set(false);
                    this.m_loadConfigFailSchedulePolicy.success();
                    transaction.addData("StatusCode", response.getStatusCode());
                    transaction.setStatus("0");
                    if (response.getStatusCode() == 304) {
                        logger.debug((Object)"Config server responds with 304 HTTP status code.");
                        ApolloConfig apolloConfig = this.m_configCache.get();
                        return apolloConfig;
                    }
                    ApolloConfig result = response.getBody();
                    if (response.getStatusCode() == 404) {
                        if (this.m_configCache.get() == null) {
                            notfoundConfig = new ApolloConfig(appId, cluster, this.m_namespace, "-1");
                            notfoundConfig.setConfigurations(new HashMap<String, String>());
                            this.m_configCache.set(notfoundConfig);
                        }
                        notfoundConfig = this.m_configCache.get();
                        return notfoundConfig;
                    }
                    logger.debug((Object)("Loaded config for " + this.m_namespace + ": " + result));
                    notfoundConfig = result;
                    return notfoundConfig;
                }
                catch (ApolloConfigStatusCodeException ex) {
                    ApolloConfigStatusCodeException statusCodeException = ex;
                    if (ex.getStatusCode() == 404) {
                        String message = String.format("Could not find config for namespace - appId: %s, cluster: %s, namespace: %s, please check whether the configs are released in Apollo!", appId, cluster, this.m_namespace);
                        statusCodeException = new ApolloConfigStatusCodeException(ex.getStatusCode(), message);
                    }
                    Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(statusCodeException));
                    transaction.setStatus(statusCodeException);
                    exception = statusCodeException;
                    if (ex.getStatusCode() == 404) {
                        break block13;
                    }
                }
                catch (Throwable ex) {
                    Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
                    transaction.setStatus(ex);
                    exception = ex;
                }
                finally {
                    transaction.complete();
                }
                onErrorSleepTime = this.m_configNeedForceRefresh.get() ? this.m_configUtil.getOnErrorRetryInterval() : this.m_loadConfigFailSchedulePolicy.fail();
            }
        }
        String message = String.format("Load Apollo Config failed - appId: %s, cluster: %s, namespace: %s, url: %s", appId, cluster, this.m_namespace, url);
        throw new ApolloConfigException(message, exception);
    }

    String assembleQueryConfigUrl(String uri, String appId, String cluster, String namespace, String dataCenter, ApolloNotificationMessages remoteMessages, ApolloConfig previousConfig) {
        String localIp;
        String path = "configs/%s/%s/%s";
        ArrayList pathParams = Lists.newArrayList((Object[])new String[]{pathEscaper.escape(appId), pathEscaper.escape(cluster), pathEscaper.escape(namespace)});
        HashMap queryParams = Maps.newHashMap();
        if (previousConfig != null) {
            queryParams.put("releaseKey", queryParamEscaper.escape(previousConfig.getReleaseKey()));
        }
        if (!Strings.isNullOrEmpty((String)dataCenter)) {
            queryParams.put("dataCenter", queryParamEscaper.escape(dataCenter));
        }
        if (!Strings.isNullOrEmpty((String)(localIp = this.m_configUtil.getLocalIp()))) {
            queryParams.put("ip", queryParamEscaper.escape(localIp));
        }
        if (remoteMessages != null) {
            queryParams.put("messages", queryParamEscaper.escape(GSON.toJson((Object)remoteMessages)));
        }
        String pathExpanded = String.format(path, pathParams.toArray());
        if (!queryParams.isEmpty()) {
            pathExpanded = pathExpanded + "?" + MAP_JOINER.join((Map)queryParams);
        }
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri + pathExpanded;
    }

    private void scheduleLongPollingRefresh() {
        this.remoteConfigLongPollService.submit(this.m_namespace, this);
    }

    public void onLongPollNotified(ServiceDTO longPollNotifiedServiceDto, ApolloNotificationMessages remoteMessages) {
        this.m_longPollServiceDto.set(longPollNotifiedServiceDto);
        this.m_remoteMessages.set(remoteMessages);
        m_executorService.submit(new Runnable(){

            @Override
            public void run() {
                RemoteConfigRepository.this.m_configNeedForceRefresh.set(true);
                RemoteConfigRepository.this.trySync();
            }
        });
    }

    private List<ServiceDTO> getConfigServices() {
        List<ServiceDTO> services = this.m_serviceLocator.getConfigServices();
        if (services.size() == 0) {
            throw new ApolloConfigException("No available config service");
        }
        return services;
    }

    static {
        GSON = new Gson();
        m_executorService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create("RemoteConfigRepository", true));
    }
}

