/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import com.google.common.base.Strings;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassLoaderUtil {
    private static final Log logger = LogFactory.getLog(ClassLoaderUtil.class);
    private static ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private static String classPath = "";

    public static ClassLoader getLoader() {
        return loader;
    }

    public static String getClassPath() {
        return classPath;
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static {
        if (loader == null) {
            logger.warn((Object)"Using system class loader");
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            URL url = loader.getResource("");
            if (url != null) {
                classPath = url.getPath();
                classPath = URLDecoder.decode(classPath, "utf-8");
            }
            if (Strings.isNullOrEmpty((String)classPath) || classPath.contains(".jar!")) {
                classPath = System.getProperty("user.dir");
            }
        }
        catch (Throwable ex) {
            classPath = System.getProperty("user.dir");
            logger.warn((Object)("Failed to locate class path, fallback to user.dir: " + classPath), ex);
        }
    }
}

