/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.tracer;

import com.ctrip.framework.apollo.tracer.internals.NullMessageProducerManager;
import com.ctrip.framework.apollo.tracer.spi.MessageProducer;
import com.ctrip.framework.apollo.tracer.spi.MessageProducerManager;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.foundation.internals.ServiceBootstrap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Tracer {
    private static final Log logger = LogFactory.getLog(Tracer.class);
    private static final MessageProducerManager NULL_MESSAGE_PRODUCER_MANAGER = new NullMessageProducerManager();
    private static volatile MessageProducerManager producerManager;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MessageProducer getProducer() {
        block6: {
            try {
                if (producerManager != null) break block6;
                Object object = lock;
                synchronized (object) {
                    if (producerManager == null) {
                        producerManager = ServiceBootstrap.loadFirst(MessageProducerManager.class);
                    }
                }
            }
            catch (Throwable ex) {
                logger.error((Object)"Failed to initialize message producer manager, use null message producer manager.", ex);
                producerManager = NULL_MESSAGE_PRODUCER_MANAGER;
            }
        }
        return producerManager.getProducer();
    }

    public static void logError(String message, Throwable cause) {
        try {
            Tracer.getProducer().logError(message, cause);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to log error for message: " + message + ", cause: " + String.valueOf(cause)), ex);
        }
    }

    public static void logError(Throwable cause) {
        try {
            Tracer.getProducer().logError(cause);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to log error for cause: " + String.valueOf(cause)), ex);
        }
    }

    public static void logEvent(String type, String name) {
        try {
            Tracer.getProducer().logEvent(type, name);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to log event for type: " + type + ", name: " + name), ex);
        }
    }

    public static void logEvent(String type, String name, String status, String nameValuePairs) {
        try {
            Tracer.getProducer().logEvent(type, name, status, nameValuePairs);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to log event for type: " + type + ", name: " + name + ", status: " + status + ", nameValuePairs: " + nameValuePairs), ex);
        }
    }

    public static Transaction newTransaction(String type, String name) {
        try {
            return Tracer.getProducer().newTransaction(type, name);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to create transaction for type: " + type + ", name: " + name), ex);
            return NULL_MESSAGE_PRODUCER_MANAGER.getProducer().newTransaction(type, name);
        }
    }

    static {
        lock = new Object();
        Tracer.getProducer();
    }
}

