/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.spi;

import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.spi.ConfigFactory;
import com.digiwin.apollo.application.spi.ConfigFactoryManager;
import com.digiwin.apollo.application.spi.ConfigRegistry;
import com.google.common.collect.Maps;
import java.util.Map;

public class DefaultConfigFactoryManager
implements ConfigFactoryManager {
    private ConfigRegistry m_registry;
    private Map<String, ConfigFactory> m_factories = Maps.newConcurrentMap();

    public DefaultConfigFactoryManager() {
        this.m_registry = ApolloInjector.getInstance(ConfigRegistry.class);
    }

    @Override
    public ConfigFactory getFactory(String namespace) {
        ConfigFactory factory = this.m_registry.getFactory(namespace);
        if (factory != null) {
            return factory;
        }
        factory = this.m_factories.get(namespace);
        if (factory != null) {
            return factory;
        }
        factory = ApolloInjector.getInstance(ConfigFactory.class, namespace);
        if (factory != null) {
            return factory;
        }
        factory = ApolloInjector.getInstance(ConfigFactory.class);
        this.m_factories.put(namespace, factory);
        return factory;
    }
}

