/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.foundation.internals;

import com.ctrip.framework.foundation.internals.NullProviderManager;
import com.ctrip.framework.foundation.internals.provider.DefaultApplicationProvider;
import com.ctrip.framework.foundation.internals.provider.DefaultNetworkProvider;
import com.ctrip.framework.foundation.internals.provider.DefaultServerProvider;
import com.ctrip.framework.foundation.spi.ProviderManager;
import com.ctrip.framework.foundation.spi.provider.Provider;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultProviderManager
implements ProviderManager {
    private static final Log logger = LogFactory.getLog(DefaultProviderManager.class);
    private Map<Class<? extends Provider>, Provider> m_providers = new LinkedHashMap<Class<? extends Provider>, Provider>();

    public DefaultProviderManager() {
        DefaultApplicationProvider applicationProvider = new DefaultApplicationProvider();
        applicationProvider.initialize();
        this.register(applicationProvider);
        DefaultNetworkProvider networkProvider = new DefaultNetworkProvider();
        networkProvider.initialize();
        this.register(networkProvider);
        DefaultServerProvider serverProvider = new DefaultServerProvider();
        serverProvider.initialize();
        this.register(serverProvider);
    }

    public synchronized void register(Provider provider) {
        this.m_providers.put(provider.getType(), provider);
    }

    @Override
    public <T extends Provider> T provider(Class<T> clazz) {
        Provider provider = this.m_providers.get(clazz);
        if (provider != null) {
            return (T)provider;
        }
        logger.error((Object)("No provider [" + clazz.getName() + "] found in DefaultProviderManager, please make sure it is registered in DefaultProviderManager "));
        return (T)NullProviderManager.provider;
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        for (Provider provider : this.m_providers.values()) {
            String value = provider.getProperty(name, null);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        if (null != this.m_providers) {
            for (Map.Entry<Class<? extends Provider>, Provider> entry : this.m_providers.entrySet()) {
                sb.append(entry.getValue()).append("\n");
            }
        }
        sb.append("(DefaultProviderManager)").append("\n");
        return sb.toString();
    }
}

