/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.platform.internals;

import com.ctrip.framework.apollo.tracer.Tracer;
import com.digiwin.apollo.platform.build.ApolloInjector;
import com.digiwin.apollo.platform.internals.ConfigRepository;
import com.digiwin.apollo.platform.internals.RepositoryChangeListener;
import com.digiwin.apollo.platform.util.ExceptionUtil;
import com.digiwin.apollo.platform.util.factory.PropertiesFactory;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConfigRepository
implements ConfigRepository {
    private static final Log logger = LogFactory.getLog(AbstractConfigRepository.class);
    private List<RepositoryChangeListener> m_listeners = Lists.newCopyOnWriteArrayList();
    protected PropertiesFactory propertiesFactory = ApolloInjector.getInstance(PropertiesFactory.class);

    protected boolean trySync() {
        try {
            this.sync();
            return true;
        }
        catch (Throwable ex) {
            Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
            logger.debug((Object)("Sync config failed, will retry. Repository " + String.valueOf(this.getClass()) + ", reason: " + ExceptionUtil.getDetailMessage(ex)));
            return false;
        }
    }

    protected abstract void sync();

    @Override
    public void addChangeListener(RepositoryChangeListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeChangeListener(RepositoryChangeListener listener) {
        this.m_listeners.remove(listener);
    }

    protected void fireRepositoryChange(String namespace, Properties newProperties) {
        for (RepositoryChangeListener listener : this.m_listeners) {
            try {
                listener.onRepositoryChange(namespace, newProperties);
            }
            catch (Throwable ex) {
                Tracer.logError(ex);
                logger.error((Object)("Failed to invoke repository change listener " + String.valueOf(listener.getClass())), ex);
            }
        }
    }
}

