/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.group.spring.boot;

import com.digiwin.apollo.group.GroupConfig;
import com.digiwin.apollo.group.GroupConfigService;
import com.digiwin.apollo.group.spring.config.ConfigPropertySourceFactory;
import com.digiwin.apollo.group.spring.util.SpringInjector;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class ApolloApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = 0;
    private static final Log logger = LogFactory.getLog(ApolloApplicationContextInitializer.class);
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final String[] APOLLO_SYSTEM_PROPERTIES = new String[]{"app.id", "apollo.cluster", "apollo.cacheDir", "apollo.accesskey.secret", "apollo.meta", "apollo.property.order.enable"};
    private final ConfigPropertySourceFactory configPropertySourceFactory = SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    private int order = 0;

    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        if (!((Boolean)environment.getProperty("apollo.bootstrap.enabled", Boolean.class, (Object)false)).booleanValue()) {
            logger.debug((Object)("Apollo bootstrap config is not enabled for context " + String.valueOf(context) + ", see property: ${apollo.bootstrap.enabled}"));
            return;
        }
        logger.debug((Object)("Apollo bootstrap config is enabled for context " + String.valueOf(context)));
        this.initialize(environment);
    }

    protected void initialize(ConfigurableEnvironment environment) {
        if (environment.getPropertySources().contains("ApolloBootstrapPropertySources")) {
            return;
        }
        String namespaces = environment.getProperty("apollo.bootstrap.namespaces", "application");
        logger.debug((Object)("Apollo bootstrap namespaces: " + namespaces));
        List namespaceList = NAMESPACE_SPLITTER.splitToList((CharSequence)namespaces);
        CompositePropertySource composite = new CompositePropertySource("ApolloBootstrapPropertySources");
        for (String namespace : namespaceList) {
            GroupConfig config = GroupConfigService.getConfig(namespace);
            composite.addPropertySource((PropertySource)this.configPropertySourceFactory.getConfigPropertySource(namespace, config));
        }
        environment.getPropertySources().addFirst((PropertySource)composite);
    }

    void initializeSystemProperty(ConfigurableEnvironment environment) {
        for (String propertyName : APOLLO_SYSTEM_PROPERTIES) {
            this.fillSystemPropertyFromEnvironment(environment, propertyName);
        }
    }

    private void fillSystemPropertyFromEnvironment(ConfigurableEnvironment environment, String propertyName) {
        if (System.getProperty(propertyName) != null) {
            return;
        }
        String propertyValue = environment.getProperty(propertyName);
        if (Strings.isNullOrEmpty((String)propertyValue)) {
            return;
        }
        System.setProperty(propertyName, propertyValue);
    }

    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        this.initializeSystemProperty(configurableEnvironment);
        Boolean eagerLoadEnabled = (Boolean)configurableEnvironment.getProperty("apollo.bootstrap.eagerLoad.enabled", Boolean.class, (Object)false);
        if (!eagerLoadEnabled.booleanValue()) {
            return;
        }
        Boolean bootstrapEnabled = (Boolean)configurableEnvironment.getProperty("apollo.bootstrap.enabled", Boolean.class, (Object)false);
        if (bootstrapEnabled.booleanValue()) {
            this.initialize(configurableEnvironment);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

