/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.foundation.Foundation;
import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.exceptions.ApolloConfigException;
import com.digiwin.apollo.application.util.ConfigUtil;
import com.digiwin.apollo.application.util.ExceptionUtil;
import com.digiwin.apollo.application.util.http.HttpRequest;
import com.digiwin.apollo.application.util.http.HttpResponse;
import com.digiwin.apollo.application.util.http.HttpUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigServiceLocator {
    private static final Log logger = LogFactory.getLog(ConfigServiceLocator.class);
    private HttpUtil m_httpUtil;
    private ConfigUtil m_configUtil;
    private AtomicReference<List<ServiceDTO>> m_configServices;
    private Type m_responseType;
    private ScheduledExecutorService m_executorService;
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    private static final Escaper queryParamEscaper = UrlEscapers.urlFormParameterEscaper();

    public ConfigServiceLocator() {
        ArrayList initial = Lists.newArrayList();
        this.m_configServices = new AtomicReference<ArrayList>(initial);
        this.m_responseType = new TypeToken<List<ServiceDTO>>(this){}.getType();
        this.m_httpUtil = ApolloInjector.getInstance(HttpUtil.class);
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.m_executorService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create("ConfigServiceLocator", true));
        this.initConfigServices();
    }

    private void initConfigServices() {
        List<ServiceDTO> customizedConfigServices = this.getCustomizedConfigService();
        if (customizedConfigServices != null) {
            this.setConfigServices(customizedConfigServices);
            return;
        }
        this.tryUpdateConfigServices();
        this.schedulePeriodicRefresh();
    }

    private List<ServiceDTO> getCustomizedConfigService() {
        String configServices = System.getProperty("apollo.configService");
        if (Strings.isNullOrEmpty((String)configServices)) {
            configServices = System.getenv("APOLLO_CONFIGSERVICE");
        }
        if (Strings.isNullOrEmpty((String)configServices)) {
            configServices = Foundation.server().getProperty("apollo.configService", null);
        }
        if (Strings.isNullOrEmpty((String)configServices)) {
            return null;
        }
        logger.warn((Object)("Located config services from apollo.configService configuration: " + configServices + ", will not refresh config services from remote meta service!"));
        String[] configServiceUrls = configServices.split(",");
        ArrayList serviceDTOS = Lists.newArrayList();
        for (String configServiceUrl : configServiceUrls) {
            configServiceUrl = configServiceUrl.trim();
            ServiceDTO serviceDTO = new ServiceDTO();
            serviceDTO.setHomepageUrl(configServiceUrl);
            serviceDTO.setAppName("apollo-configservice");
            serviceDTO.setInstanceId(configServiceUrl);
            serviceDTOS.add(serviceDTO);
        }
        return serviceDTOS;
    }

    public List<ServiceDTO> getConfigServices() {
        if (this.m_configServices.get().isEmpty()) {
            this.updateConfigServices();
        }
        return this.m_configServices.get();
    }

    private boolean tryUpdateConfigServices() {
        try {
            this.updateConfigServices();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void schedulePeriodicRefresh() {
        this.m_executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                logger.debug((Object)"refresh config services");
                Tracer.logEvent("Apollo.MetaService", "periodicRefresh");
                ConfigServiceLocator.this.tryUpdateConfigServices();
            }
        }, this.m_configUtil.getRefreshInterval(), this.m_configUtil.getRefreshInterval(), this.m_configUtil.getRefreshIntervalTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateConfigServices() {
        String url = this.assembleMetaServiceUrl();
        HttpRequest request = new HttpRequest(url);
        int maxRetries = 2;
        Throwable exception = null;
        for (int i = 0; i < maxRetries; ++i) {
            Transaction transaction = Tracer.newTransaction("Apollo.MetaService", "getConfigService");
            transaction.addData("Url", url);
            try {
                HttpResponse response = this.m_httpUtil.doGet(request, this.m_responseType);
                transaction.setStatus("0");
                List services = (List)response.getBody();
                if (services != null && !services.isEmpty()) {
                    this.setConfigServices(services);
                    return;
                }
                this.logConfigService("Empty response!");
                continue;
            }
            catch (Throwable ex) {
                Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
                transaction.setStatus(ex);
                exception = ex;
            }
            finally {
                transaction.complete();
            }
            try {
                this.m_configUtil.getOnErrorRetryIntervalTimeUnit().sleep(this.m_configUtil.getOnErrorRetryInterval());
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new ApolloConfigException(String.format("Get config services failed from %s", url), exception);
    }

    private void setConfigServices(List<ServiceDTO> services) {
        this.m_configServices.set(services);
        this.logConfigServices(services);
    }

    private String assembleMetaServiceUrl() {
        String domainName = this.m_configUtil.getMetaServerDomainName();
        String appId = this.m_configUtil.getAppId();
        String localIp = this.m_configUtil.getLocalIp();
        HashMap queryParams = Maps.newHashMap();
        queryParams.put("appId", queryParamEscaper.escape(appId));
        if (!Strings.isNullOrEmpty((String)localIp)) {
            queryParams.put("ip", queryParamEscaper.escape(localIp));
        }
        return domainName + "/services/config?" + MAP_JOINER.join((Map)queryParams);
    }

    private void logConfigServices(List<ServiceDTO> serviceDtos) {
        for (ServiceDTO serviceDto : serviceDtos) {
            this.logConfigService(serviceDto.getHomepageUrl());
        }
    }

    private void logConfigService(String serviceUrl) {
        Tracer.logEvent("Apollo.Config.Services", serviceUrl);
    }
}

