/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.gateway.filter.DWEaiCallbackMethodLocateFilter;
import com.digiwin.gateway.filter.DWEaiServiceMethodLocateFilter;
import com.digiwin.gateway.filter.EaiHealthCheckFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@ConditionalOnClass(value={DWEAIHeaderRepository.class})
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
public class DWEAIServiceAutoConfiguration {
    private static final int EAI_HEALTH_CHECK_FILTER_ORDER = 200;
    private static final int DWEAISERVICEMETHOD_LOCATE_FILTER_ORDER = 201;

    @Bean(value={"DWEAIHeaderRepository"})
    public DWEAIHeaderRepository getDWEAIHeaderRepository() {
        return new DWEAIHeaderRepository();
    }

    @Bean(value={"DWEAIServiceParser"})
    public DWEAIServiceDefinitionParser getDWEAIServiceDefinitionParser(DWEAIHeaderRepository eaiHeaderRepository) {
        return new DWEAIServiceDefinitionParser(eaiHeaderRepository);
    }

    @Configuration
    @Profile(value={"EAI"})
    @AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
    public static class EaiConfiguration {
        @Autowired
        private ApplicationContext context;

        @Bean
        public FilterRegistrationBean<EaiHealthCheckFilter> eaiHealthCheckFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new EaiHealthCheckFilter());
            registration.addUrlPatterns(new String[]{"/eai"});
            registration.setOrder(200);
            return registration;
        }

        @Bean
        public DWEaiServiceMethodLocateFilter dwEaiMethodLocateFilterBean(DWContainerContext containerContext) {
            return new DWEaiServiceMethodLocateFilter(containerContext);
        }

        @Bean
        public FilterRegistrationBean<DWEaiServiceMethodLocateFilter> dwEaiMethodLocateFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.context.getBean(DWEaiServiceMethodLocateFilter.class));
            registration.addUrlPatterns(new String[]{"/eai"});
            registration.setOrder(201);
            return registration;
        }

        @Bean
        public DWEaiCallbackMethodLocateFilter dwEaiCallbackMethodLocateFilterBean(DWContainerContext containerContext) {
            return new DWEaiCallbackMethodLocateFilter(containerContext);
        }

        @Bean
        public FilterRegistrationBean<DWEaiCallbackMethodLocateFilter> dwEaiCallbackMethodLocateFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.context.getBean(DWEaiCallbackMethodLocateFilter.class));
            registration.addUrlPatterns(new String[]{"/eai/callback"});
            registration.setOrder(201);
            return registration;
        }
    }
}

