/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.gateway.filter.AllowAnonymousFilter;
import com.digiwin.gateway.filter.CacFilter;
import com.digiwin.gateway.filter.ExceptionFilter;
import com.digiwin.gateway.filter.SidecarProtocalFilter;
import com.digiwin.gateway.filter.StandardHeaderFilter;
import com.digiwin.gateway.filter.TokenFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
public class FilterConfiguration {
    private static final int SIDECAR_PROTOCAL_FILTER_ORDER = Integer.MIN_VALUE;
    private static final int STANDARD_HEADER_FILTER_ORDER = -2147483647;
    private static final int ALLOW_ANONYMOUS_FILTER_ORDER = 100000;
    public static final int TOKEN_FILTER_ORDER = 100001;
    private static final int CAC_FILTER_ORDER = 100002;

    @Configuration
    public static class ExceptionConfiguration {
        @Bean
        public ExceptionFilter exceptionFilter() {
            return new ExceptionFilter();
        }
    }

    @Configuration
    @Profile(value={"RestfulService", "RestfulStandard", "EAI"})
    public static class StandardOutputConfiguration {
        @Bean
        public FilterRegistrationBean<StandardHeaderFilter> standardHeaderFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new StandardHeaderFilter());
            registration.addUrlPatterns(new String[]{"/restful/*"});
            registration.addUrlPatterns(StandardHeaderFilter.getExtraUrlPatterns());
            registration.setOrder(-2147483647);
            return registration;
        }
    }

    @Configuration
    @Profile(value={"RestfulService", "RestfulStandard", "EAI"})
    @AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
    public static class TokenConfiguration {
        @Autowired
        private ApplicationContext context;
        private String[] urlPatterns = new String[]{"/restful/service/*", "/restful/standard/*", "/eai", "/eai/callback"};

        @Bean
        public FilterRegistrationBean<AllowAnonymousFilter> allowAnonymousFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new AllowAnonymousFilter());
            registration.addUrlPatterns(this.urlPatterns);
            registration.setOrder(100000);
            return registration;
        }

        @Bean
        public TokenFilter restfulTokenFilterBean() {
            return new TokenFilter();
        }

        @Bean
        public FilterRegistrationBean<TokenFilter> restfulTokenFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.context.getBean(TokenFilter.class));
            registration.addUrlPatterns(this.urlPatterns);
            registration.setOrder(100001);
            return registration;
        }

        @Bean
        @Profile(value={"CAC"})
        public CacFilter restfulCacFilterBean() {
            return new CacFilter();
        }

        @Bean
        @Profile(value={"CAC"})
        public FilterRegistrationBean<CacFilter> restfulCacFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.context.getBean(CacFilter.class));
            registration.addUrlPatterns(this.urlPatterns);
            registration.setOrder(100002);
            return registration;
        }
    }

    @Configuration
    public static class SidecarProtocalConfiguration {
        @Bean
        public FilterRegistrationBean<SidecarProtocalFilter> sidecarProtocalFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new SidecarProtocalFilter());
            registration.addUrlPatterns(new String[]{"/sidecar/*"});
            registration.setOrder(Integer.MIN_VALUE);
            return registration;
        }
    }
}

