/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWDruidSpringAopConfiguration;
import com.digiwin.app.autoconfigure.DWDruidStatViewServletConfiguration;
import com.digiwin.app.autoconfigure.DWDruidWebStatFilterConfiguration;
import com.digiwin.app.autoconfigure.condition.DWDefaultDWDaoEnableCondition;
import com.digiwin.app.common.DWAdapterConfigUtils;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={DWDruidSpringAopConfiguration.class, DWDruidStatViewServletConfiguration.class, DWDruidWebStatFilterConfiguration.class})
public class DWDaoDynamicDataSourceConfiguration {
    @Bean(name={"dw-dataSource"})
    @Conditional(value={DWDefaultDWDaoEnableCondition.class})
    @ConfigurationProperties(value="dap.dwdao.default.datasource")
    public DataSource defaultDWDaoDataSource(ApplicationContext context, DWAdapterConfigUtils adapterConfigUtils) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwdao.default.datasource");
        BindResult result = binder.bind(cfgPropertyName, Bindable.of(DataSourceProperties.class), (BindHandler)handler);
        DataSource defaultDataSource = ((DataSourceProperties)result.get()).initializeDataSourceBuilder().build();
        return defaultDataSource;
    }
}

