/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWLogOperationCondition;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.log.operation.concurrent.DWLogOperationWriter;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.config.DWLogOperationThreadProperties;
import com.digiwin.app.log.operation.dao.DWLogOperationDaoImp;
import com.digiwin.app.log.operation.dao.ILogOperationDao;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class DWLogOperationAutoConfiguration {
    private static Log log = LogFactory.getLog(DWLogOperationAutoConfiguration.class);

    @Bean(name={"dw-log-operation-configuration"})
    @Conditional(value={DWLogOperationCondition.class})
    public DWLogOperationProperties dwLogOperationConfig() {
        DWLogOperationProperties returnValue = new DWLogOperationProperties();
        String operateLogEnabled = DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.enabled", (String)"false");
        if (BooleanUtils.toBoolean((String)operateLogEnabled)) {
            returnValue.setEnabled(BooleanUtils.toBoolean((String)operateLogEnabled));
            returnValue.setLogSqlEnabled(BooleanUtils.toBoolean((String)DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.logSqlEnabled", (String)"false")));
            returnValue.setLogErrorEnabled(BooleanUtils.toBoolean((String)DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.logErrorEnabled", (String)"false")));
        }
        log.info((Object)returnValue.toString());
        return returnValue;
    }

    @Bean(name={"dw-log-operation-db-dataSource"})
    @ConditionalOnBean(name={"dw-log-operation-configuration"})
    public DataSource dwLogOperationDaoDataSource(@Qualifier(value="dw-log-operation-configuration") DWLogOperationProperties dwLogOperationConfig) {
        String driverClassName = DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.datasource.DriverClassName", (String)"org.mariadb.jdbc.Driver");
        String dbUrl = DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.datasource.url");
        String dbUsername = DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.datasource.username");
        String dbPassword = DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.datasource.password");
        BasicDataSource defaultDataSource = new BasicDataSource();
        defaultDataSource.setDriverClassName(driverClassName);
        defaultDataSource.setUrl(dbUrl);
        defaultDataSource.setUsername(dbUsername);
        defaultDataSource.setPassword(dbPassword);
        return defaultDataSource;
    }

    @Bean(name={"dw-log-operation-db-proxyDataSource"})
    @ConditionalOnBean(name={"dw-log-operation-db-dataSource"})
    public TransactionAwareDataSourceProxy transactionAwareDataSourceProxy(@Qualifier(value="dw-log-operation-db-dataSource") DataSource dataSource) {
        TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy(dataSource);
        return transactionAwareDataSourceProxy;
    }

    @Bean(name={"dw-log-operation-db-queryRunner"})
    @ConditionalOnBean(name={"dw-log-operation-db-dataSource"})
    public QueryRunner queryRunner(@Qualifier(value="dw-log-operation-db-proxyDataSource") TransactionAwareDataSourceProxy transactionAwareDataSourceProxy) {
        QueryRunner queryRunner = new QueryRunner((DataSource)transactionAwareDataSourceProxy);
        return queryRunner;
    }

    @Bean(name={"dw-log-operation-db-dao"})
    @ConditionalOnBean(name={"dw-log-operation-db-queryRunner"})
    public DWDaoImpl dwDaoImpl(@Qualifier(value="dw-log-operation-db-queryRunner") QueryRunner queryRunner) {
        DWDaoImpl dao = new DWDaoImpl(queryRunner);
        boolean mapUnderscoreToCamelCase = true;
        String settingValue = DWApplicationConfigUtils.getProperty((String)"dwDaoUnderScoreToCamelCase", (String)"true");
        if ("false".equalsIgnoreCase(settingValue)) {
            mapUnderscoreToCamelCase = false;
        }
        dao.setMapUnderscoreToCamelCase(mapUnderscoreToCamelCase);
        return dao;
    }

    @Bean(name={"dw-log-operation-thread-configuration"})
    @ConditionalOnBean(name={"dw-log-operation-configuration"})
    public DWLogOperationThreadProperties dwLogOperationThreadProperties(@Qualifier(value="dw-log-operation-configuration") DWLogOperationProperties dwLogOperationConfig) {
        DWLogOperationThreadProperties threadProperties = new DWLogOperationThreadProperties();
        boolean operateLogEnabled = dwLogOperationConfig.isEnabled();
        if (operateLogEnabled) {
            threadProperties.setCorePoolSize(new Integer(DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.writer.thread.corePoolSize", (String)"5")).intValue());
            threadProperties.setMaximumPoolSize(new Integer(DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.writer.thread.maximumPoolSize", (String)"20")).intValue());
            threadProperties.setKeepAliveTime(new Long(DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.writer.thread.keepAliveTime", (String)"30000")).longValue());
            threadProperties.setWorkQueueSize(new Integer(DWApplicationConfigUtils.getProperty((String)"dap.dwlog.operation.writer.thread.workQueueSize", (String)"10")).intValue());
        }
        log.info((Object)threadProperties.toString());
        return threadProperties;
    }

    @Bean(name={"dw-log-operation-writer"})
    @ConditionalOnBean(name={"dw-log-operation-thread-configuration"})
    public DWLogOperationWriter dwLogOperationWriter(@Qualifier(value="dw-log-operation-db-dao") DWDao dao, @Qualifier(value="dw-log-operation-thread-configuration") DWLogOperationThreadProperties threadProperties) {
        DWLogOperationWriter dwLogOperationWriter = new DWLogOperationWriter();
        dwLogOperationWriter.setThreadProperties(threadProperties);
        dwLogOperationWriter.setDaoLogOperation(dao);
        return dwLogOperationWriter;
    }

    @Bean(name={"dw-log-operation-dao"})
    @ConditionalOnBean(name={"dw-log-operation-writer"})
    public ILogOperationDao dwLogOperationDao(@Qualifier(value="dw-log-operation-writer") DWLogOperationWriter dwLogOperationWriter) {
        DWLogOperationDaoImp dwLogOperationDao = new DWLogOperationDaoImp(dwLogOperationWriter);
        return dwLogOperationDao;
    }
}

