/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWCacheEnableCondition;
import com.digiwin.app.cache.DWCacheKeyGenerator;
import com.digiwin.app.common.DWApplicationConfigUtils;
import java.time.Duration;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class DWCacheAutoConfiguration
extends CachingConfigurerSupport {
    @Bean
    @Conditional(value={DWCacheEnableCondition.class})
    public RedisCacheManager cacheManager(RedisConnectionFactory connectionFactory) throws Exception {
        String keyExpiredTime = DWApplicationConfigUtils.getProperty((String)"keyExpiredTime");
        if (StringUtils.isEmpty((CharSequence)keyExpiredTime)) {
            keyExpiredTime = "86400";
        }
        RedisCacheConfiguration conf_dwapiplatform = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(Long.parseLong(keyExpiredTime)));
        HashMap<String, RedisCacheConfiguration> cacheConfigurations = new HashMap<String, RedisCacheConfiguration>();
        cacheConfigurations.put("dwapiplatform", conf_dwapiplatform);
        return RedisCacheManager.RedisCacheManagerBuilder.fromConnectionFactory((RedisConnectionFactory)connectionFactory).withInitialCacheConfigurations(cacheConfigurations).build();
    }

    @Bean(value={"dwCacheKeyGenerator"})
    public KeyGenerator keyGenerator() {
        boolean isClosedCache = DWApplicationConfigUtils.isClosedCache();
        if (isClosedCache) {
            return null;
        }
        return new DWCacheKeyGenerator();
    }
}

