/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWJavaxValidationEnableCondition;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.validation.DWResourceBundleLocator;
import javax.annotation.PostConstruct;
import javax.validation.MessageInterpolator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@Configuration
public class DWModuleValidationAutoConfiguration {
    @PostConstruct
    public void init() {
        DWModuleSpringUtils.registerModuleConfigurationClass(DWModuleValidationAutoConfiguration.class);
    }

    @Bean(name={"dao-LocalValidatorFactoryBean"})
    @Conditional(value={DWJavaxValidationEnableCondition.class})
    public LocalValidatorFactoryBean getLocalValidatorFactoryBean() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        DWResourceBundleLocator rbLocator = new DWResourceBundleLocator();
        ResourceBundleMessageInterpolator interpolator = new ResourceBundleMessageInterpolator((ResourceBundleLocator)rbLocator);
        factoryBean.setMessageInterpolator((MessageInterpolator)interpolator);
        return factoryBean;
    }

    @Bean(name={"dao-MethodValidationPostProcessor"})
    @Conditional(value={DWJavaxValidationEnableCondition.class})
    public MethodValidationPostProcessor getMethodValidationPostProcessor(@Autowired @Qualifier(value="dao-LocalValidatorFactoryBean") LocalValidatorFactoryBean factoryBean) {
        MethodValidationPostProcessor processor = new MethodValidationPostProcessor();
        processor.setValidatorFactory((ValidatorFactory)factoryBean);
        return processor;
    }
}

