/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWDaoDynamicDataSourceConfiguration;
import com.digiwin.app.autoconfigure.condition.DWDbEnableCondition;
import com.digiwin.app.common.DWAdapterConfigUtils;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.MultiTenancyInterceptor;
import com.digiwin.app.log.utils.DWLogUtils;
import io.seata.rm.datasource.DataSourceProxy;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@Import(value={DWDaoDynamicDataSourceConfiguration.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class DWDaoAutoConfiguration {
    @Deprecated
    @Bean(name={"dw-dataSource"})
    @ConditionalOnMissingBean(name={"dw-dataSource"})
    @Conditional(value={DWDbEnableCondition.class})
    public DataSource basicDataSource(DWAdapterConfigUtils adapterConfigUtils) {
        String driverClassName = DWApplicationConfigUtils.getProperty((String)"jdbcDriverClassName");
        String dbUrl = DWApplicationConfigUtils.getProperty((String)"dbUrl");
        String dbUsername = DWApplicationConfigUtils.getProperty((String)"dbUsername");
        String dbPassword = DWApplicationConfigUtils.getProperty((String)"dbPassword");
        String dbConnectionInitialSize = DWApplicationConfigUtils.getProperty((String)"dbConnectionInitialSize");
        String dbConnectionMinIdle = DWApplicationConfigUtils.getProperty((String)"dbConnectionMinIdle");
        String dbConnectionMaxIdle = DWApplicationConfigUtils.getProperty((String)"dbConnectionMaxIdle");
        String dbConnectionMaxTotal = DWApplicationConfigUtils.getProperty((String)"dbConnectionMaxTotal");
        String dbConnectionMaxWaitMillis = DWApplicationConfigUtils.getProperty((String)"dbConnectionMaxWaitMillis");
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(driverClassName);
        basicDataSource.setUrl(dbUrl);
        basicDataSource.setUsername(dbUsername);
        basicDataSource.setPassword(dbPassword);
        basicDataSource.setInitialSize(Integer.valueOf(dbConnectionInitialSize).intValue());
        basicDataSource.setMinIdle(Integer.valueOf(dbConnectionMinIdle).intValue());
        if (dbConnectionMaxIdle != null) {
            basicDataSource.setMaxIdle(Integer.valueOf(dbConnectionMaxIdle).intValue());
        } else {
            basicDataSource.setMaxIdle(Integer.valueOf(dbConnectionMaxTotal).intValue());
        }
        basicDataSource.setMaxTotal(Integer.valueOf(dbConnectionMaxTotal).intValue());
        basicDataSource.setMaxWaitMillis((long)Integer.valueOf(dbConnectionMaxWaitMillis).intValue());
        return basicDataSource;
    }

    @Bean(name={"dw-proxyDataSource"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public DataSource transactionAwareDataSourceProxy(@Qualifier(value="dw-dataSource") DataSource dataSource) {
        String seataDsProxyEnabled = DWApplicationConfigUtils.getProperty((String)"seata.dwdao.datasource.proxy.enabled", (String)"false");
        Object returnDataSourceProxy = DWLogUtils.getSeataEnabled() && BooleanUtils.toBoolean((String)seataDsProxyEnabled) ? new DataSourceProxy(dataSource) : new TransactionAwareDataSourceProxy(dataSource);
        return returnDataSourceProxy;
    }

    @Bean(name={"dw-queryRunner"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public QueryRunner queryRunner(@Qualifier(value="dw-proxyDataSource") DataSource dataSourceProxy) {
        QueryRunner queryRunner = new QueryRunner(dataSourceProxy);
        return queryRunner;
    }

    @Bean(name={"dw-dao"})
    @Primary
    @Conditional(value={DWDbEnableCondition.class})
    public DWDaoImpl dwDaoImpl(@Qualifier(value="dw-queryRunner") QueryRunner queryRunner) {
        DWDaoImpl dao = new DWDaoImpl(queryRunner);
        boolean mapUnderscoreToCamelCase = true;
        String settingValue = DWApplicationConfigUtils.getProperty((String)"dwDaoUnderScoreToCamelCase", (String)"true");
        if ("false".equalsIgnoreCase(settingValue)) {
            mapUnderscoreToCamelCase = false;
        }
        dao.setMapUnderscoreToCamelCase(mapUnderscoreToCamelCase);
        boolean insertDefaultValueFromMetadata = false;
        String insertDefaultValueFromMetadataString = DWApplicationConfigUtils.getProperty((String)"dap.dwdao.insert.default-value-from-metadata", (String)"false");
        if ("true".equalsIgnoreCase(insertDefaultValueFromMetadataString)) {
            insertDefaultValueFromMetadata = true;
        }
        dao.setInsertDefaultValueFromMetadata(insertDefaultValueFromMetadata);
        return dao;
    }

    @Bean(name={"daoMultiTenancyInterceptor"})
    @Conditional(value={DWDbEnableCondition.class})
    public MultiTenancyInterceptor multiTenancyInterceptor() {
        MultiTenancyInterceptor multiTenancyInterceptor = new MultiTenancyInterceptor();
        return multiTenancyInterceptor;
    }

    @Bean(name={"daoMultiTenancyAdvisor"})
    @Conditional(value={DWDbEnableCondition.class})
    public Advisor daoMultiTenancyAdvisor(@Qualifier(value="daoMultiTenancyInterceptor") MultiTenancyInterceptor multiTenancyInterceptor) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* com.digiwin.app.dao.DWDaoImpl.*(..)) and args(String,..)");
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)multiTenancyInterceptor);
        return advisor;
    }

    @Bean(name={"dw-transactionManager"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public DataSourceTransactionManager dataSourceTransactionManager(@Qualifier(value="dw-proxyDataSource") DataSource dataSourceProxy) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(dataSourceProxy);
        return dataSourceTransactionManager;
    }
}

