/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.log.config.DWSeataPropertyConfiguration;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@ConditionalOnProperty(prefix="seata.", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class DWDtxAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWDtxAutoConfiguration.class);
    private static final String BEAN_DW_SEATAPROPERTY_CONFIGURATION = "dw-seata-property-configuration";
    private static final String BEAN_DW_GLOBALTRANSACTIONSCANNER = "dw-seata-globalTransactionScanner";

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean(value={"dw-seata-property-configuration"})
    @ConditionalOnMissingBean(value={DWSeataPropertyConfiguration.class})
    public DWSeataPropertyConfiguration dwSeataPropertyConfiguration() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata properties");
        }
        return new DWSeataPropertyConfiguration();
    }

    @Bean(value={"dw-seata-globalTransactionScanner"})
    @DependsOn(value={"dw-seata-property-configuration", "failureHandler"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public GlobalTransactionScanner globalTransactionScanner(DWSeataPropertyConfiguration seataProperties, FailureHandler failureHandler) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure GlobalTransactionScanner");
        }
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }
}

