/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.staticpattern;

import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.fuse.config.DapPropertiesOutboundKey;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.digiwin.gateway.service.eai.EaiService;
import com.digiwin.iam.HttpRequester;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class DWStaticPatternCodeAutoConfiguration {
    public DWStaticPatternCodeAutoConfiguration(Environment environment, @Value(value="${thisDapUrl:}") String thisDapUrl, @Value(value="${dwExceptionOutputDebugInfo:true}") String outputDebugInfoValue) {
        DWInnerInvocationUtils.setThisDapUrl((String)thisDapUrl);
        StandardExceptionOutput.setOutputDebugInfo((!"false".equalsIgnoreCase(outputDebugInfoValue) ? 1 : 0) != 0);
        EaiService.setEaiUrl((String)environment.getProperty("eaiUrl"));
        this.initDWFuseComponent(environment);
    }

    public void initDWFuseComponent(Environment environment) {
        this.initDWFuseOption(environment);
        this.initDWFuseOutboundConfig(environment);
    }

    public void initDWFuseOption(Environment environment) {
        String isIgnoreUnassignedXRateLimitHeaderKey = DapPropertiesOptionKey.isIgnoreUnassignedXRateLimitHeader();
        String isXRateLimitHeaderOnKey = DapPropertiesOptionKey.isXRateLimitHeaderOn();
        String isCollectMetricsKey = DapPropertiesOptionKey.isCollectMetrics();
        String isAutoFuseHttpStatusCodeKey = DapPropertiesOptionKey.isAutoFuseHttpStatusCode();
        String inboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.inboundErrorHttpStatusCode();
        String outboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.outboundErrorHttpStatusCode();
        String isIgnoreUnassignedXRateLimitHeader = environment.getProperty(isIgnoreUnassignedXRateLimitHeaderKey, String.valueOf(true));
        String isXRateLimitHeaderOn = environment.getProperty(isXRateLimitHeaderOnKey, String.valueOf(true));
        String isCollectMetrics = environment.getProperty(isCollectMetricsKey, String.valueOf(false));
        String isAutoFuseHttpStatusCode = environment.getProperty(isAutoFuseHttpStatusCodeKey, String.valueOf(true));
        String inboundErrorHttpStatusCode = environment.getProperty(inboundErrorHttpStatusCodeKey, String.valueOf(429));
        String outboundErrorHttpStatusCode = environment.getProperty(outboundErrorHttpStatusCodeKey, String.valueOf(503));
        DWFuseOption option = new DWFuseOption();
        option.setIgnoreUnassignedXRateLimitHeader(isIgnoreUnassignedXRateLimitHeader);
        option.setXRateLimitHeaderOn(isXRateLimitHeaderOn);
        option.setCollectMetrics(isCollectMetrics);
        option.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
        option.setInboundErrorHttpStatusCode(inboundErrorHttpStatusCode);
        option.setOutboundErrorHttpStatusCode(outboundErrorHttpStatusCode);
        HttpRequester.setDefaultDWFuseOption((DWFuseOption)option);
    }

    public void initDWFuseOutboundConfig(Environment environment) {
        String key = "iam";
        String enableKey = DapPropertiesOutboundKey.enable((String)key);
        String failureRateKey = DapPropertiesOutboundKey.failureRate((String)key);
        String openSecKey = DapPropertiesOutboundKey.openSec((String)key);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize((String)key);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize((String)key);
        String enable = environment.getProperty(enableKey, "false");
        String failureRate = environment.getProperty(failureRateKey, String.valueOf(50));
        String openSec = environment.getProperty(openSecKey, String.valueOf(60));
        String halfOpenCalculateSize = environment.getProperty(halfOpenCalculateSizeKey, String.valueOf(10));
        String closeCalculateSize = environment.getProperty(closeCalculateSizeKey, String.valueOf(100));
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        HttpRequester.setDefaultOutBoundConfig((OutboundConfig)outboundConfig);
    }
}

