/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWCacheEnableCondition;
import com.digiwin.app.cache.DWCacheKeyGenerator;
import com.digiwin.app.service.DWServiceContext;
import java.time.Duration;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@EnableCaching
@Configuration
public class DWCacheAutoConfiguration
extends CachingConfigurerSupport
implements EnvironmentAware {
    @Value(value="${keyExpiredTime:}")
    private String keyExpiredTime = null;
    @Value(value="${appId}")
    private String appId;
    private Environment environment;

    @Bean
    @Conditional(value={DWCacheEnableCondition.class})
    public RedisCacheManager cacheManager(RedisConnectionFactory connectionFactory) throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.keyExpiredTime)) {
            this.keyExpiredTime = "86400";
        }
        RedisCacheConfiguration conf_dwapiplatform = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(Long.parseLong(this.keyExpiredTime)));
        HashMap<String, RedisCacheConfiguration> cacheConfigurations = new HashMap<String, RedisCacheConfiguration>();
        cacheConfigurations.put("dwapiplatform", conf_dwapiplatform);
        return RedisCacheManager.RedisCacheManagerBuilder.fromConnectionFactory((RedisConnectionFactory)connectionFactory).withInitialCacheConfigurations(cacheConfigurations).build();
    }

    @Bean(value={"cacheManager"})
    @ConditionalOnMissingBean(value={CacheManager.class})
    public NoOpCacheManager cacheManagerOnDWCacheDisabled() {
        return new NoOpCacheManager();
    }

    @Bean(value={"dwCacheKeyGenerator"})
    public KeyGenerator keyGenerator() {
        boolean cacheEnabled = DWCacheEnableCondition.isCacheEnabled(this.environment);
        if (!cacheEnabled) {
            return null;
        }
        DWCacheKeyGenerator.registerReplacement((String)"token", () -> DWServiceContext.getContext().getToken());
        DWCacheKeyGenerator.registerReplacement((String)"appId", () -> this.appId);
        return new DWCacheKeyGenerator();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

