/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWLogOperationCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.properties.DWDaoDataSetProperties;
import com.digiwin.app.dao.properties.DWDaoMgmtFieldProperties;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.dao.properties.DWDaoSqlFilterProperties;
import com.digiwin.app.log.operation.concurrent.DWLogOperationWriter;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.config.DWLogOperationThreadProperties;
import com.digiwin.app.log.operation.dao.DWLogOperationDaoImp;
import com.digiwin.app.log.operation.dao.ILogOperationDao;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class DWLogOperationAutoConfiguration {
    private static Log log = LogFactory.getLog(DWLogOperationAutoConfiguration.class);

    @Bean(name={"dw-log-operation-configuration"})
    @Conditional(value={DWLogOperationCondition.class})
    public DWLogOperationProperties dwLogOperationConfig(ApplicationContext context) {
        DWLogOperationProperties returnValue = null;
        String operateLogEnabled = context.getEnvironment().getProperty("dap.dwlog.operation.enabled", "false");
        if (BooleanUtils.toBoolean((String)operateLogEnabled)) {
            Binder binder = Binder.get((Environment)context.getEnvironment());
            IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
            ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation");
            BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationProperties.class), (BindHandler)handler);
            returnValue = (DWLogOperationProperties)bindResult.get();
        } else {
            returnValue = new DWLogOperationProperties();
        }
        log.info((Object)returnValue.toString());
        return returnValue;
    }

    @Bean(name={"dw-log-operation-db-dataSource"})
    @ConditionalOnBean(name={"dw-log-operation-configuration"})
    public DataSource dwLogOperationDaoDataSource(@Qualifier(value="dw-log-operation-configuration") DWLogOperationProperties dwLogOperationConfig, ApplicationContext context) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.datasource");
        BindResult result = binder.bind(cfgPropertyName, Bindable.of(DataSourceProperties.class), (BindHandler)handler);
        DataSource defaultDataSource = ((DataSourceProperties)result.get()).initializeDataSourceBuilder().build();
        return defaultDataSource;
    }

    @Bean(name={"dw-log-operation-db-proxyDataSource"})
    @ConditionalOnBean(name={"dw-log-operation-db-dataSource"})
    public TransactionAwareDataSourceProxy transactionAwareDataSourceProxy(@Qualifier(value="dw-log-operation-db-dataSource") DataSource dataSource) {
        TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy(dataSource);
        return transactionAwareDataSourceProxy;
    }

    @Bean(name={"dw-log-operation-db-queryRunner"})
    @ConditionalOnBean(name={"dw-log-operation-db-dataSource"})
    public QueryRunner queryRunner(@Qualifier(value="dw-log-operation-db-proxyDataSource") TransactionAwareDataSourceProxy transactionAwareDataSourceProxy) {
        QueryRunner queryRunner = new QueryRunner((DataSource)transactionAwareDataSourceProxy);
        return queryRunner;
    }

    @Bean(name={"dw-log-operation-db-dao-sqlDialect"})
    public DWSQLDialect dwSqlDialect(Environment environment) throws Exception {
        DWMySQLDialect dialect = new DWMySQLDialect();
        return dialect;
    }

    @Bean(value={"dw-log-operation-db-dao-properties"})
    public DWDaoProperties daoProperties(Environment environment) {
        DWDaoProperties daoProperties = new DWDaoProperties();
        DWDaoMgmtFieldProperties mgmtFieldProperties = new DWDaoMgmtFieldProperties();
        DWDaoDataSetProperties dataSetProperties = new DWDaoDataSetProperties();
        DWDaoSqlFilterProperties daoSqlFilterProperties = new DWDaoSqlFilterProperties();
        daoProperties.setMgmtFieldProperties(mgmtFieldProperties);
        daoProperties.setDataSetProperties(dataSetProperties);
        daoProperties.setDaoSqlFilterProperties(daoSqlFilterProperties);
        return daoProperties;
    }

    @Bean(name={"dw-log-operation-db-dao"})
    @ConditionalOnBean(name={"dw-log-operation-db-queryRunner"})
    public DWDaoImpl dwDaoImpl(Environment environment, @Qualifier(value="dw-log-operation-db-queryRunner") QueryRunner queryRunner, @Qualifier(value="dw-log-operation-db-dao-sqlDialect") DWSQLDialect dialect, @Qualifier(value="dw-log-operation-db-dao-properties") DWDaoProperties daoProperties) {
        DWDaoImpl dao = new DWDaoImpl(queryRunner);
        dao.setProperties(daoProperties);
        boolean mapUnderscoreToCamelCase = true;
        String settingValue = environment.getProperty("dwDaoUnderScoreToCamelCase", "true");
        if ("false".equalsIgnoreCase(settingValue)) {
            mapUnderscoreToCamelCase = false;
        }
        dao.setMapUnderscoreToCamelCase(mapUnderscoreToCamelCase);
        return dao;
    }

    @Bean(name={"dw-log-operation-thread-configuration"})
    @ConditionalOnBean(name={"dw-log-operation-configuration"})
    public DWLogOperationThreadProperties dwLogOperationThreadProperties(@Qualifier(value="dw-log-operation-configuration") DWLogOperationProperties dwLogOperationConfig, ApplicationContext context) {
        DWLogOperationThreadProperties threadProperties = null;
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.writer.thread");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationThreadProperties.class), (BindHandler)handler);
        threadProperties = (DWLogOperationThreadProperties)bindResult.get();
        log.info((Object)threadProperties.toString());
        return threadProperties;
    }

    @Bean(name={"dw-log-operation-writer"})
    @ConditionalOnBean(name={"dw-log-operation-thread-configuration"})
    public DWLogOperationWriter dwLogOperationWriter(@Qualifier(value="dw-log-operation-db-dao") DWDao dao, @Qualifier(value="dw-log-operation-thread-configuration") DWLogOperationThreadProperties threadProperties) {
        DWLogOperationWriter dwLogOperationWriter = new DWLogOperationWriter();
        dwLogOperationWriter.setThreadProperties(threadProperties);
        dwLogOperationWriter.setDaoLogOperation(dao);
        return dwLogOperationWriter;
    }

    @Bean(name={"dw-log-operation-dao"})
    @ConditionalOnBean(name={"dw-log-operation-writer"})
    public ILogOperationDao dwLogOperationDao(@Qualifier(value="dw-log-operation-writer") DWLogOperationWriter dwLogOperationWriter) {
        DWLogOperationDaoImp dwLogOperationDao = new DWLogOperationDaoImp(dwLogOperationWriter);
        return dwLogOperationDao;
    }
}

