/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.staticpattern;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.fuse.config.DapPropertiesOutboundKey;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.digiwin.gateway.service.eai.EaiService;
import com.digiwin.iam.HttpRequester;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class DWStaticPatternCodeAutoConfiguration {
    public DWStaticPatternCodeAutoConfiguration(Environment environment, @Value(value="${thisDapUrl:}") String thisDapUrl, @Value(value="${dwExceptionOutputDebugInfo:true}") String outputDebugInfoValue, @Value(value="${dap.exception.message.i18n.enable:false}") boolean enableErrorMessageI18N, @Value(value="${dap.exception.message.i18n.exclude.codes:}") String excludeCodes) {
        DWInnerInvocationUtils.setThisDapUrl((String)thisDapUrl);
        StandardExceptionOutput.setOutputDebugInfo((!"false".equalsIgnoreCase(outputDebugInfoValue) ? 1 : 0) != 0);
        StandardExceptionOutput.setEnableExceptionMessageI18N((boolean)enableErrorMessageI18N);
        Set<String> errorCodes = this.getDefaultErrorCodes();
        if (Objects.nonNull(excludeCodes) && !excludeCodes.trim().isEmpty()) {
            String[] codes = excludeCodes.trim().split(",");
            errorCodes.addAll(Arrays.asList(codes));
        }
        StandardExceptionOutput.setExcludeErrorCodes(errorCodes);
        EaiService.setEaiUrl((String)environment.getProperty("eaiUrl"));
        String otherModuleResourceNameSeparator = environment.getProperty("dap.modular.class-loader.other-module-resource-name-separator", "#");
        DWModuleClassLoader.setOtherModuleResourceNameSeparator((String)otherModuleResourceNameSeparator);
        this.initDWFuseComponent(environment);
    }

    private Set<String> getDefaultErrorCodes() {
        HashSet<String> set = new HashSet<String>();
        set.add("10900");
        set.add("10901");
        set.add("10902");
        set.add("11001");
        set.add("11002");
        set.add("11002_1");
        set.add("15001");
        set.add("15002");
        return set;
    }

    public void initDWFuseComponent(Environment environment) {
        this.initDWFuseOption(environment);
        this.initDWFuseOutboundConfig(environment);
    }

    public void initDWFuseOption(Environment environment) {
        String isIgnoreUnassignedXRateLimitHeaderKey = DapPropertiesOptionKey.isIgnoreUnassignedXRateLimitHeader();
        String isXRateLimitHeaderOnKey = DapPropertiesOptionKey.isXRateLimitHeaderOn();
        String isCollectMetricsKey = DapPropertiesOptionKey.isCollectMetrics();
        String isAutoFuseHttpStatusCodeKey = DapPropertiesOptionKey.isAutoFuseHttpStatusCode();
        String inboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.inboundErrorHttpStatusCode();
        String outboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.outboundErrorHttpStatusCode();
        String isIgnoreUnassignedXRateLimitHeader = environment.getProperty(isIgnoreUnassignedXRateLimitHeaderKey, String.valueOf(true));
        String isXRateLimitHeaderOn = environment.getProperty(isXRateLimitHeaderOnKey, String.valueOf(true));
        String isCollectMetrics = environment.getProperty(isCollectMetricsKey, String.valueOf(false));
        String isAutoFuseHttpStatusCode = environment.getProperty(isAutoFuseHttpStatusCodeKey, String.valueOf(true));
        String inboundErrorHttpStatusCode = environment.getProperty(inboundErrorHttpStatusCodeKey, String.valueOf(429));
        String outboundErrorHttpStatusCode = environment.getProperty(outboundErrorHttpStatusCodeKey, String.valueOf(503));
        DWFuseOption option = new DWFuseOption();
        option.setIgnoreUnassignedXRateLimitHeader(isIgnoreUnassignedXRateLimitHeader);
        option.setXRateLimitHeaderOn(isXRateLimitHeaderOn);
        option.setCollectMetrics(isCollectMetrics);
        option.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
        option.setInboundErrorHttpStatusCode(inboundErrorHttpStatusCode);
        option.setOutboundErrorHttpStatusCode(outboundErrorHttpStatusCode);
        HttpRequester.setDefaultDWFuseOption((DWFuseOption)option);
    }

    public void initDWFuseOutboundConfig(Environment environment) {
        String key = "iam";
        String enableKey = DapPropertiesOutboundKey.enable((String)key);
        String failureRateKey = DapPropertiesOutboundKey.failureRate((String)key);
        String openSecKey = DapPropertiesOutboundKey.openSec((String)key);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize((String)key);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize((String)key);
        String enable = environment.getProperty(enableKey, "false");
        String failureRate = environment.getProperty(failureRateKey, String.valueOf(50));
        String openSec = environment.getProperty(openSecKey, String.valueOf(60));
        String halfOpenCalculateSize = environment.getProperty(halfOpenCalculateSizeKey, String.valueOf(10));
        String closeCalculateSize = environment.getProperty(closeCalculateSizeKey, String.valueOf(100));
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        HttpRequester.setDefaultOutBoundConfig((OutboundConfig)outboundConfig);
    }
}

