/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWScheduleEnableCondition;
import com.digiwin.app.schedule.DWDistributedScheduleProperties;
import com.digiwin.app.schedule.DWQuartzProperties;
import com.digiwin.app.schedule.DWScheduleProperties;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.dbservice.DWScheduleContactDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleTimeDBService;
import com.digiwin.app.schedule.quartz.DWQuartz;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;

@Configuration
public class DWScheduleAutoConfiguration {
    @Bean(value={"dw-distributed-schedule-properties"})
    public DWDistributedScheduleProperties distributedScheduleProperties(Environment environment) {
        DWDistributedScheduleProperties distributedScheduleProperties = new DWDistributedScheduleProperties();
        distributedScheduleProperties.setEnabled(Boolean.parseBoolean(environment.getProperty("distributedScheduleEnable", "false")));
        distributedScheduleProperties.setTargetJobAppUrl(environment.getProperty("distributedScheduleTargetUrl"));
        distributedScheduleProperties.setSimpleMaster(Boolean.parseBoolean(environment.getProperty("distributedScheduleSimpleMaster", "false")));
        distributedScheduleProperties.setHigherMaster(Boolean.parseBoolean(environment.getProperty("distributedScheduleHigherMaster", "false")));
        distributedScheduleProperties.setMasterUrl(environment.getProperty("distributedScheduleMasterUrl"));
        distributedScheduleProperties.setWorker(Boolean.parseBoolean(environment.getProperty("distributedScheduleWorker", "false")));
        distributedScheduleProperties.setWorkerUrl(environment.getProperty("distributedScheduleWorkerUrl"));
        distributedScheduleProperties.setWorkerId(environment.getProperty("distributedScheduleWorkerId"));
        distributedScheduleProperties.setHttpClientConnectionMaxTotal(Integer.parseInt(environment.getProperty("distributedScheduleHttpClientMaxTotal", "1500")));
        distributedScheduleProperties.setHttpClientConnectionRequestTimeout(Integer.parseInt(environment.getProperty("distributedScheduleConnectRequestTimeout", "30")));
        distributedScheduleProperties.setHttpClientConnectionTimeout(Integer.parseInt(environment.getProperty("distributedScheduleConnectTimeout", "30")));
        distributedScheduleProperties.setHttpClientConnectionSocketTimeout(Integer.parseInt(environment.getProperty("distributedScheduleSocketTimeout", "30")));
        distributedScheduleProperties.setHttpClientMaxRetries(Integer.parseInt(environment.getProperty("distributedScheduleMaxRetries", "3")));
        return distributedScheduleProperties;
    }

    @Bean(value={"dw-schedule-properties"})
    public DWScheduleProperties scheduleProperties(Environment environment, DWDistributedScheduleProperties distributedScheduleProperties) {
        DWScheduleProperties scheduleProperties = new DWScheduleProperties();
        scheduleProperties.setDistributedScheduleProperties(distributedScheduleProperties);
        DWScheduleProperties.setDefaultProperties((DWScheduleProperties)scheduleProperties);
        scheduleProperties.setEnabled(DWScheduleEnableCondition.isScheduleEnabled(environment));
        if (scheduleProperties.isEnabled()) {
            scheduleProperties.setRemoteInvocation("true".equalsIgnoreCase(environment.getProperty("scheduleRemoteInvocation", "false")));
            scheduleProperties.setEmailSMTPHost(environment.getProperty("scheduleEmailSmtpHost"));
            String portValue = environment.getProperty("scheduleEmailPort");
            if (portValue == null || portValue.isEmpty() || portValue.equals("@scheduleEmailPort@")) {
                scheduleProperties.setEmailSMTPPort(25);
            } else {
                scheduleProperties.setEmailSMTPPort(Integer.parseInt(portValue));
            }
            String userName = environment.getProperty("scheduleEmailUsername");
            scheduleProperties.setEmailUserName(userName);
            scheduleProperties.setEmailPassword(environment.getProperty("scheduleEmailPassword"));
            scheduleProperties.setEmailTransportType(Integer.valueOf(environment.getProperty("scheduleEmailTypeOfConnection")).intValue());
            scheduleProperties.setEmailSender(userName);
        }
        return scheduleProperties;
    }

    @Bean(name={"DWQuartz"})
    @DependsOn(value={"dw-rdbMetadataLoader", "DWScheduleDBService", "DWScheduleRecordDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWQuartz quartz(final ConfigurableEnvironment environment, @Qualifier(value="dap-application-propertysource") PropertiesPropertySource dapApplicationPropertySource) throws Exception {
        Object source = dapApplicationPropertySource.getSource();
        Properties dapProperties = (Properties)source;
        dapProperties.setProperty("org.quartz.dataSource.quartzDataSource.driver", environment.getProperty("jdbcDriverClassName"));
        dapProperties.setProperty("org.quartz.dataSource.quartzDataSource.URL", environment.getProperty("dbUrl"));
        dapProperties.setProperty("org.quartz.dataSource.quartzDataSource.user", environment.getProperty("dbUsername"));
        dapProperties.setProperty("org.quartz.dataSource.quartzDataSource.password", environment.getProperty("dbPassword"));
        DWQuartzProperties.buildDWQuartzProperties((Properties)dapProperties);
        Properties props = new Properties();
        MutablePropertySources propSrcs = environment.getPropertySources();
        final Set keys = StreamSupport.stream(propSrcs.spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).collect(Collectors.toSet());
        DWQuartz quartz = new DWQuartz(new Properties(){

            @Override
            public String getProperty(String key) {
                return environment.getProperty(key);
            }

            @Override
            public String getProperty(String key, String defaultValue) {
                return environment.getProperty(key, defaultValue);
            }

            @Override
            public Enumeration<?> propertyNames() {
                return Collections.enumeration(keys);
            }

            @Override
            public Set<String> stringPropertyNames() {
                return keys;
            }
        });
        DWQuartz.setInstance((DWQuartz)quartz);
        return quartz;
    }

    @Bean(name={"DWScheduleContext"})
    @DependsOn(value={"DWScheduleDBService", "DWScheduleRecordDBService", "DWScheduleTimeDBService", "DWScheduleContactDBService", "DWQuartz"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleContext scheduleContext(ConfigurableEnvironment environment) {
        String isScheduleJsonOutputString = environment.getProperty("isScheduleJsonOutput", "false");
        boolean isScheduleJsonOutput = false;
        if ("true".equalsIgnoreCase(isScheduleJsonOutputString)) {
            isScheduleJsonOutput = true;
        }
        DWScheduleContext scheduleContext = new DWScheduleContext();
        DWScheduleContext.setInstance((DWScheduleContext)scheduleContext);
        scheduleContext.setScheduleJsonOutput(isScheduleJsonOutput);
        return scheduleContext;
    }

    @Bean(name={"DWScheduleDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleDBService scheduleDBService() {
        DWScheduleDBService scheduleDBService = new DWScheduleDBService();
        DWScheduleDBService.setInstance((DWScheduleDBService)scheduleDBService);
        return scheduleDBService;
    }

    @Bean(name={"DWScheduleRecordDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleRecordDBService scheduleRecordDBService() {
        DWScheduleRecordDBService scheduleRecordDBService = new DWScheduleRecordDBService();
        DWScheduleRecordDBService.setInstance((DWScheduleRecordDBService)scheduleRecordDBService);
        return scheduleRecordDBService;
    }

    @Bean(name={"DWScheduleTimeDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleTimeDBService scheduleTimeDBService() {
        DWScheduleTimeDBService scheduleTimeDBService = new DWScheduleTimeDBService();
        DWScheduleTimeDBService.setInstance((DWScheduleTimeDBService)scheduleTimeDBService);
        return scheduleTimeDBService;
    }

    @Bean(name={"DWScheduleContactDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleContactDBService scheduleContactDBService() {
        DWScheduleContactDBService scheduleContactDBService = new DWScheduleContactDBService();
        DWScheduleContactDBService.setInstance((DWScheduleContactDBService)scheduleContactDBService);
        return scheduleContactDBService;
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutting down.");
        DWQuartz.shutdown();
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutdown complete.");
    }
}

