/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.event;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.gateway.event.DWInitEntryPointConfig;
import com.digiwin.gateway.event.DWInitializationEvent;
import com.digiwin.gateway.event.DWMobileInitializationEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWInitializationEventAutoConfiguration {
    private static Log log = LogFactory.getLog(DWInitializationEventAutoConfiguration.class);
    public static String KEY_MOBILE_URL = "mobileUrl";
    public static String KEY_MOBILE_API_INIT = "mobileApiInit";

    public DWInitializationEventAutoConfiguration(Environment environment) {
        try {
            String api = environment.getProperty(KEY_MOBILE_API_INIT, "");
            log.info((Object)("-DWMobileInitializationEvent-check required property's key->" + KEY_MOBILE_API_INIT + "=" + api));
            if (!api.isEmpty()) {
                log.info((Object)"-DWMobileInitializationEvent-register initialization event.");
                DWMobileInitializationEvent initializationEvent = new DWMobileInitializationEvent();
                String url = environment.getProperty(KEY_MOBILE_URL, "");
                initializationEvent.setMobileUrl(url);
                initializationEvent.setMobileApiInitPath(api);
                DWInitEntryPointConfig.register((DWInitializationEvent)initializationEvent, (int)DWMobileInitializationEvent.ORDER);
            }
        }
        catch (Exception e) {
            throw new DWRuntimeException("register initialization event failed. check logs for details!", (Throwable)e);
        }
    }
}

