/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.EAIExceptionDefaultHandler;
import com.digiwin.app.eai.EAIExceptionHandler;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.gateway.filter.DWEaiCallbackMethodLocateFilter;
import com.digiwin.gateway.filter.DWEaiServiceMethodLocateFilter;
import com.digiwin.gateway.filter.EaiHealthCheckFilter;
import com.digiwin.gateway.filter.FilterConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={DWEAIHeaderRepository.class})
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
public class DWEAIServiceAutoConfiguration {
    private static final int EAI_HEALTH_CHECK_FILTER_ORDER = 200;
    private static final int DWEAISERVICEMETHOD_LOCATE_FILTER_ORDER = 201;
    private static Log log = LogFactory.getLog(DWEAIServiceAutoConfiguration.class);

    @Bean(value={"EAIExceptionHandler"})
    public EAIExceptionHandler eaiExceptionHandler(Environment environment) {
        EAIExceptionDefaultHandler eaiExceptionHandler = new EAIExceptionDefaultHandler();
        try {
            String eaiExceptionHandlerClazz = environment.getProperty("eaiExceptionHandler", "");
            if (StringUtils.isBlank((CharSequence)eaiExceptionHandlerClazz) || "@eaiExceptionHandler@".equals(eaiExceptionHandlerClazz)) {
                log.info((Object)"use com.digiwin.app.eai.EAIExceptionDefaultHandler as EAIExceptionHandler");
                return eaiExceptionHandler;
            }
            DWApplicationClassLoader applicationClassLoader = DWApplicationClassLoader.getInstance();
            Class clazz = applicationClassLoader.loadClass(eaiExceptionHandlerClazz);
            Object instance = clazz.newInstance();
            log.info((Object)String.format("use %s as EAIExceptionHandler", eaiExceptionHandlerClazz));
            return (EAIExceptionHandler)instance;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error((Object)"load custom EAIExceptionHandler error", (Throwable)e);
            log.info((Object)"use com.digiwin.app.eai.EAIExceptionDefaultHandler as EAIExceptionHandler");
            return eaiExceptionHandler;
        }
    }

    @Bean(value={"DWEaiRestfulUrlProperties"})
    @ConditionalOnMissingBean(value={DWEAIProperties.class})
    public DWEAIProperties getEaiRestfulUrlProperties(Environment env, FilterConfiguration.TokenConfiguration tokenConfiguration) {
        String customId;
        DWEAIProperties properties = new DWEAIProperties();
        String customBasePath = env.getProperty("eaiRestfulUrl");
        if (customBasePath != null) {
            customBasePath = customBasePath.trim();
        }
        if ("@eaiRestfulUrl@".equals(customBasePath)) {
            customBasePath = null;
        }
        if (customBasePath != null && customBasePath.length() > 0) {
            properties.setRestfulServiceBasePath(customBasePath);
        }
        if ((customId = env.getProperty("eaiRestfulCustomId")) != null) {
            customId = customId.trim();
        }
        if ("@eaiRestfulCustomId@".equals(customId)) {
            customId = null;
        }
        if (customId != null && customId.length() > 0) {
            properties.setRestfulServicePathIdentifier(customId);
        }
        String appId = env.getProperty("appId");
        properties.setHostProd(env.getProperty("eaiHostProd", appId));
        properties.setHostId(env.getProperty("eaiHostId", appId));
        properties.setHostUid(env.getProperty("eaiHostUid", appId));
        properties.setHostVer(env.getProperty("eaiHostVer", "1.0.0"));
        properties.setHostRetryTimes(env.getProperty("eaiHostRetrytimes", ""));
        properties.setHostRetryInterval(env.getProperty("eaiHostRetryinterval", ""));
        properties.setHostConcurrence(env.getProperty("eaiHostConcurrence", ""));
        String defaultIp = "0.0.0.0";
        try {
            defaultIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LogFactory.getLog(DWEAIServiceAutoConfiguration.class).error((Object)"Get Host Address failed!", (Throwable)e);
        }
        properties.setHostIp(env.getProperty("eaiHostIp", defaultIp));
        properties.setServerUrl(env.getProperty("eaiUrl"));
        properties.setServerRegisterServicePath(env.getProperty("eaiUrlRegSrv", "/CROSS/RESTful/regSrv"));
        properties.setStandardHostProduct(Boolean.parseBoolean(env.getProperty("eaiHostProdIsStandardProduct")));
        DWEAIProperties.setProperties((DWEAIProperties)properties);
        tokenConfiguration.registerUrlPatterns(properties.getRestfulServicePath(), properties.getRestfulServiceCallbackPath());
        return properties;
    }

    @Bean(value={"DWEAIHeaderRepository"})
    public DWEAIHeaderRepository getDWEAIHeaderRepository() {
        return new DWEAIHeaderRepository();
    }

    @Bean(value={"DWEAIServiceParser"})
    public DWEAIServiceDefinitionParser getDWEAIServiceDefinitionParser(DWEAIHeaderRepository eaiHeaderRepository) {
        return new DWEAIServiceDefinitionParser(eaiHeaderRepository);
    }

    @Configuration
    @AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
    public static class EaiConfiguration {
        @Autowired
        private ApplicationContext context;

        @Bean
        public EaiHealthCheckFilter eaiHealthCheckFilterBean() {
            return new EaiHealthCheckFilter();
        }

        @Bean
        public FilterRegistrationBean<EaiHealthCheckFilter> eaiHealthCheckFilter(DWEAIProperties properties) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.eaiHealthCheckFilterBean());
            registration.addUrlPatterns(new String[]{properties.getRestfulServicePath()});
            registration.setOrder(200);
            return registration;
        }

        @Bean
        public DWEaiServiceMethodLocateFilter dwEaiMethodLocateFilterBean(DWContainerContext containerContext) {
            return new DWEaiServiceMethodLocateFilter(containerContext);
        }

        @Bean
        public FilterRegistrationBean<DWEaiServiceMethodLocateFilter> dwEaiMethodLocateFilter(DWEAIProperties properties) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.context.getBean(DWEaiServiceMethodLocateFilter.class));
            String restfulServicePath = properties.getRestfulServicePath();
            registration.addUrlPatterns(new String[]{restfulServicePath});
            registration.setOrder(201);
            return registration;
        }

        @Bean
        public DWEaiCallbackMethodLocateFilter dwEaiCallbackMethodLocateFilterBean(DWContainerContext containerContext) {
            return new DWEaiCallbackMethodLocateFilter(containerContext);
        }

        @Bean
        public FilterRegistrationBean<DWEaiCallbackMethodLocateFilter> dwEaiCallbackMethodLocateFilter(DWEAIProperties properties) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)this.context.getBean(DWEaiCallbackMethodLocateFilter.class));
            registration.addUrlPatterns(new String[]{properties.getRestfulServiceCallbackPath()});
            registration.setOrder(201);
            return registration;
        }
    }
}

