/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.redis.service.DefaultRedisService;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DWDefaultClientResources;
import io.lettuce.core.resource.NettyCustomizer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class DWRedisAutoConfiguration {
    @Bean
    public DWRedisService redisService(RedisTemplate<String, Object> redisTemplate) {
        DefaultRedisService redisService = new DefaultRedisService();
        redisService.setOperator(redisTemplate);
        return redisService;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redis = new RedisTemplate();
        redis.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redis.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redis.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redis.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redis.setConnectionFactory(redisConnectionFactory);
        redis.afterPropertiesSet();
        return redis;
    }

    @Bean
    public ClientResources clientResources() {
        NettyCustomizer nettyCustomizer = new NettyCustomizer(){

            public void afterChannelInitialized(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(30, 30, 30)});
                channel.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof IdleStateEvent) {
                            ctx.disconnect();
                        }
                    }
                }});
            }

            public void afterBootstrapInitialized(Bootstrap bootstrap) {
            }
        };
        return DWDefaultClientResources.builder().nettyCustomizer(nettyCustomizer).build();
    }
}

