/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.servicechain.ex;

import com.digiwin.app.autoconfigure.condition.DWServiceChainAutoAttachHeaderEnableCondition;
import com.digiwin.app.service.DWServiceChainDataProviderManager;
import com.digiwin.app.service.callback.DWServiceChainInitializer;
import com.digiwin.app.service.callback.amqp.DWRestoreServiceContextRequestHeadersInitializer;
import com.digiwin.app.service.callback.amqp.DWSpringAmqpServiceContextInitializer;
import com.digiwin.app.service.interceptor.DWServiceChainInitializerBaseInterceptor;
import com.digiwin.app.service.processor.amqp.ex.DWReceiveSpringAmqpMessageHeadersPostProcessor;
import java.util.Collections;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.Message;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;

@Configuration
@Conditional(value={DWServiceChainAutoAttachHeaderEnableCondition.class})
public class DWServiceChainInitializerAutoConfiguration {
    @Bean(value={"dw-spring-amqp-service-context-request-headers-initializer"})
    public DWServiceChainInitializer<Message> springAmqpServiceChainInitializer(DWServiceChainDataProviderManager dataProviderManager) {
        return new DWRestoreServiceContextRequestHeadersInitializer(dataProviderManager);
    }

    @Bean(value={"dw-spring-amqp-service-context-initializer"})
    @ConditionalOnProperty(name={"dap.service-chain.initializer.remove-service-context"}, havingValue="true", matchIfMissing=true)
    public DWServiceChainInitializer<Message> DWSpringAmqpServiceContextInitializer() {
        return new DWSpringAmqpServiceContextInitializer();
    }

    @Bean(value={"dw-receiv-spring-amqp-message-headers-post-processor"})
    public DWReceiveSpringAmqpMessageHeadersPostProcessor receiveSpringAmqpMessageHeadersPostProcessor(ObjectProvider<List<DWServiceChainInitializer<Message>>> listObjectProvider) {
        List initializerList = (List)listObjectProvider.getIfAvailable(Collections::emptyList);
        OrderComparator.sort((List)initializerList);
        return new DWReceiveSpringAmqpMessageHeadersPostProcessor(initializerList);
    }

    @Bean(value={"dw-spring-amqp-message-listener-executor-aop"})
    public DefaultPointcutAdvisor springAmqpMessageListenerInterceptor(DWServiceChainDataProviderManager serviceChainDataProviderManager, ObjectProvider<List<DWServiceChainInitializer<Message>>> listObjectProvider) {
        List initializerList = (List)listObjectProvider.getIfAvailable(Collections::emptyList);
        OrderComparator.sort((List)initializerList);
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.springframework.amqp.core.MessageListener+) && execution(public * onMessage(org.springframework.amqp.core.Message, ..))");
        DWServiceChainInitializerBaseInterceptor<Message, DWServiceChainInitializer<Message>> messageListenerInterceptor = new DWServiceChainInitializerBaseInterceptor<Message, DWServiceChainInitializer<Message>>(initializerList){};
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)messageListenerInterceptor);
        return advisor;
    }
}

