/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.autoconfigure.DWDaoDynamicDataSourceConfiguration;
import com.digiwin.app.autoconfigure.condition.DWDbEnableCondition;
import com.digiwin.app.common.DWAdapterConfigUtils;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.filter.DWResultSetFilterChain;
import com.digiwin.app.dao.filter.IDWResultSetFilter;
import com.digiwin.app.dao.properties.DWDaoDataSetProperties;
import com.digiwin.app.dao.properties.DWDaoDataSourceProperties;
import com.digiwin.app.dao.properties.DWDaoMgmtFieldProperties;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.dao.properties.DWDaoResultSetFilterProperties;
import com.digiwin.app.dao.properties.DWDaoSqlFilterProperties;
import com.digiwin.app.dao.security.AESUtil;
import com.digiwin.app.data.generator.DWFieldValueGeneratorEnum;
import com.digiwin.app.data.generator.DWFieldValueGeneratorFactory;
import com.digiwin.app.data.generator.DWSQLDateValueGenerator;
import com.digiwin.app.data.generator.DWSQLTimeValueGenerator;
import com.digiwin.app.data.generator.DWSQLTimestampValueGenerator;
import com.digiwin.app.data.generator.DWTenantsidValueGenerator;
import com.digiwin.app.data.generator.DWUUIDValueGenerator;
import com.digiwin.app.data.generator.IDWFieldValueGenerator;
import com.digiwin.app.schedule.DWDistributedScheduleWorkersProperties;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.DWBasicDataSource;
import org.apache.commons.dbutils.DWQueryTimeoutQueryRunner;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={DWDaoDynamicDataSourceConfiguration.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class DWDaoAutoConfiguration {
    private static final String KEY_FALSE = "false";
    DWDaoProperties daoProperties;

    @Bean(value={"dw-dao-properties"})
    public DWDaoProperties daoProperties(Environment environment) {
        this.daoProperties = new DWDaoProperties();
        DWDaoMgmtFieldProperties mgmtFieldProperties = new DWDaoMgmtFieldProperties();
        DWDaoDataSetProperties dataSetProperties = new DWDaoDataSetProperties();
        DWDaoSqlFilterProperties daoSqlFilterProperties = new DWDaoSqlFilterProperties();
        DWDaoResultSetFilterProperties daoResultSetFilterProperties = new DWDaoResultSetFilterProperties();
        mgmtFieldProperties.setMgmtFieldAliasName(environment.getProperty("mgmtFieldAliasName", ""));
        mgmtFieldProperties.setMgmtFieldEnabled(Boolean.parseBoolean(environment.getProperty("mgmtFieldEnabled", KEY_FALSE)));
        mgmtFieldProperties.setMgmtFieldIgnoreCustomValue(Boolean.parseBoolean(environment.getProperty("mgmtFieldIgnoreCustomValue", "true")));
        mgmtFieldProperties.setMgmtFieldResolver(environment.getProperty("mgmtFieldResolver", "com.digiwin.app.dao.filter.DWProfileManagementFieldResolver"));
        mgmtFieldProperties.setMgmtFieldUpdateMappings(environment.getProperty("mgmtFieldUpdateMappings"));
        mgmtFieldProperties.setMgmtFieldInsertMappings(environment.getProperty("mgmtFieldInsertMappings"));
        dataSetProperties.setDwdaoCalculateMaxSeqEnabled(Boolean.parseBoolean(environment.getProperty("dwdaoCalculateMaxSeqEnabled", KEY_FALSE)));
        dataSetProperties.setDwdaoCalculateMaxSeqFieldName(environment.getProperty("dwdaoCalculateMaxSeqFieldName", "seq"));
        dataSetProperties.setDwdaoSelectVersionFieldEnabled(Boolean.parseBoolean(environment.getProperty("dwdaoSelectVersionFieldEnabled", KEY_FALSE)));
        dataSetProperties.setDwdaoInsertDefaultValueFromMetadata(Boolean.parseBoolean(environment.getProperty("dap.dwdao.insert.default-value-from-metadata", KEY_FALSE)));
        dataSetProperties.setDwdaoUpdateDefaultValueFromMetadata(Boolean.parseBoolean(environment.getProperty("dap.dwdao.update.default-value-from-metadata", KEY_FALSE)));
        dataSetProperties.setQueryPaginationByObjectEnabled(Boolean.parseBoolean(environment.getProperty("dap.dwdao.query.pagination-by-object", "true")));
        dataSetProperties.setSqlOrderTypeOfExecution(environment.getProperty("dap.dwdao.sql.execute.order.type"));
        dataSetProperties.setDwdaoExceptionSQLMask(Boolean.parseBoolean(environment.getProperty("dap.dwdao.exception.sql.mask", KEY_FALSE)));
        daoSqlFilterProperties.setDataPermSqlFilter(environment.getProperty("dataPermSqlFilter"));
        daoSqlFilterProperties.setDwsqlFilterChianCustom(environment.getProperty("dwsqlFilterChianCustom"));
        daoResultSetFilterProperties.setResultSetFilterClassNames(environment.getProperty("dap.dwdao.resultset.filter.class.names"));
        this.daoProperties.setMgmtFieldProperties(mgmtFieldProperties);
        this.daoProperties.setDataSetProperties(dataSetProperties);
        this.daoProperties.setDaoSqlFilterProperties(daoSqlFilterProperties);
        this.daoProperties.setDaoResultSetFilterProperties(daoResultSetFilterProperties);
        DWDaoProperties.setDefaultDaoProperties((DWDaoProperties)this.daoProperties);
        return this.daoProperties;
    }

    @Bean(value={"dw-datasource-properties"})
    @DependsOn(value={"dw-http-client-properties"})
    public DWDaoDataSourceProperties dataSourceProperties(Environment environment) {
        DWDaoDataSourceProperties dataSourceProperties = new DWDaoDataSourceProperties();
        dataSourceProperties.setDbConnectionInitialSize(Integer.parseInt(environment.getProperty("dbConnectionInitialSize", "3")));
        dataSourceProperties.setDbConnectionMaxIdle(environment.getProperty("dbConnectionMaxIdle") == null ? null : Integer.valueOf(Integer.parseInt(environment.getProperty("dbConnectionMaxIdle"))));
        dataSourceProperties.setDbConnectionMaxTotal(Integer.parseInt(environment.getProperty("dbConnectionMaxTotal", "20")));
        dataSourceProperties.setDbConnectionMaxWaitMillis(Integer.parseInt(environment.getProperty("dbConnectionMaxWaitMillis", "60000")));
        dataSourceProperties.setDbConnectionMinIdle(Integer.parseInt(environment.getProperty("dbConnectionMinIdle", "3")));
        dataSourceProperties.setDbPassword(environment.getProperty("dbPassword"));
        dataSourceProperties.setDbPasswordEncryptionKey(environment.getProperty("dbPasswordEncryptionKey"));
        String dbUrl = environment.getProperty("dbUrl");
        if (StringUtils.isNotBlank((CharSequence)dbUrl)) {
            dataSourceProperties.setDbUrl(environment.getProperty("dbUrl"));
        } else {
            PropertySource propertySource;
            String dbUrlType = environment.getProperty("dbUrlType");
            String dbUrlHost = environment.getProperty("dbUrlHost");
            String dbUrlPort = environment.getProperty("dbUrlPort");
            String dbUrlDatabase = environment.getProperty("dbUrlDatabase");
            String dbUrlArgs = environment.getProperty("dbUrlArgs");
            StringBuilder dbUrlCombination = new StringBuilder();
            dbUrlCombination.append("jdbc:" + dbUrlType + "://" + dbUrlHost);
            if (!"".equals(dbUrlPort)) {
                dbUrlCombination.append(":" + dbUrlPort);
            }
            dbUrlCombination.append("/" + dbUrlDatabase);
            if (!"".equals(dbUrlArgs)) {
                dbUrlCombination.append("?" + dbUrlArgs);
            }
            if ((propertySource = ((ConfigurableEnvironment)environment).getPropertySources().get("dap-application-propertysource")) instanceof PropertiesPropertySource) {
                PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
                ((Map)propertiesPropertySource.getSource()).put("dbUrl", dbUrlCombination.toString());
            }
            if (propertySource instanceof EnumerablePropertySource) {
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                Properties properties = (Properties)enumerablePropertySource.getSource();
                properties.setProperty("dbUrl", dbUrlCombination.toString());
            }
            dataSourceProperties.setDbUrl(dbUrlCombination.toString());
        }
        dataSourceProperties.setDbUsername(environment.getProperty("dbUsername"));
        dataSourceProperties.setDwDaoUnderScoreToCamelCase(Boolean.parseBoolean(environment.getProperty("dwDaoUnderScoreToCamelCase", "true")));
        dataSourceProperties.setJdbcDriverClassName(environment.getProperty("jdbcDriverClassName"));
        System.setProperty("dbRetryTimes", environment.getProperty("dap.db.connection.retryTimes", "3"));
        System.setProperty("dbRetryIntervalMillis", environment.getProperty("dap.db.connection.retryIntervalMillis", "2000"));
        if (Boolean.parseBoolean(environment.getProperty("distributedScheduleEnable")) && Boolean.parseBoolean(environment.getProperty("distributedScheduleWorker"))) {
            DWHttpClient client = new DWHttpClient();
            HttpPost post = new HttpPost(environment.getProperty("distributedScheduleMasterUrl") + "/restful/service/DWSys/IScheduleService/getWorkerConfig");
            DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties workerConfig = null;
            try {
                Map result = (Map)client.executeAndGetDWHttpResponseEntity((HttpUriRequest)post, Map.class).getResult();
                if (Boolean.parseBoolean(result.get("success").toString())) {
                    if (result.get("data") == null) {
                        throw new RuntimeException("can not get valid distributed schedule worker configuration");
                    }
                    Gson gson = new Gson();
                    workerConfig = (DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties)gson.fromJson(JSON.toJSONString(result.get("data")), DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties.class);
                } else {
                    throw new RuntimeException(result.get("message").toString());
                }
                dataSourceProperties.setDbPassword(workerConfig.getDbPassword());
                dataSourceProperties.setDbUrl(workerConfig.getDbUrl());
                dataSourceProperties.setDbUsername(workerConfig.getDbUserName());
                DistributedScheduleUtils.workerProperties = workerConfig;
            }
            catch (DWHttpFailedException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return dataSourceProperties;
    }

    @Deprecated
    @Bean(name={"dw-dataSource"})
    @ConditionalOnMissingBean(name={"dw-dataSource"})
    @Conditional(value={DWDbEnableCondition.class})
    public DataSource basicDataSource(DWAdapterConfigUtils adapterConfigUtils, @Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties) {
        String driverClassName = dataSourceProperties.getJdbcDriverClassName();
        String dbUrl = dataSourceProperties.getDbUrl();
        String dbUsername = dataSourceProperties.getDbUsername();
        String dbPassword = dataSourceProperties.getDbPassword();
        String dbPasswordEncryptionKey = dataSourceProperties.getDbPasswordEncryptionKey();
        if (dbPasswordEncryptionKey != null && !"".equals(dbPasswordEncryptionKey.trim())) {
            dbPassword = AESUtil.decode((String)dbPassword, (String)dbPasswordEncryptionKey);
        }
        int dbConnectionInitialSize = dataSourceProperties.getDbConnectionInitialSize();
        int dbConnectionMinIdle = dataSourceProperties.getDbConnectionMinIdle();
        Integer dbConnectionMaxIdle = dataSourceProperties.getDbConnectionMaxIdle();
        int dbConnectionMaxTotal = dataSourceProperties.getDbConnectionMaxTotal();
        int dbConnectionMaxWaitMillis = dataSourceProperties.getDbConnectionMaxWaitMillis();
        DWBasicDataSource basicDataSource = new DWBasicDataSource();
        basicDataSource.setDriverClassName(driverClassName);
        basicDataSource.setUrl(dbUrl);
        basicDataSource.setUsername(dbUsername);
        basicDataSource.setPassword(dbPassword);
        basicDataSource.setInitialSize(dbConnectionInitialSize);
        basicDataSource.setMinIdle(dbConnectionMinIdle);
        if (dbConnectionMaxIdle != null) {
            basicDataSource.setMaxIdle(dbConnectionMaxIdle.intValue());
        } else {
            basicDataSource.setMaxIdle(dbConnectionMaxTotal);
        }
        basicDataSource.setMaxTotal(dbConnectionMaxTotal);
        basicDataSource.setMaxWaitMillis((long)dbConnectionMaxWaitMillis);
        return basicDataSource;
    }

    @Bean(name={"dw-proxyDataSource"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public TransactionAwareDataSourceProxy transactionAwareDataSourceProxy(@Qualifier(value="dw-dataSource") DataSource dataSource, @Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties) {
        TransactionAwareDataSourceProxy returnDataSourceProxy = new TransactionAwareDataSourceProxy(dataSource);
        return returnDataSourceProxy;
    }

    @Bean(name={"dw-queryRunner"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public QueryRunner queryRunner(@Qualifier(value="dw-proxyDataSource") DataSource dataSourceProxy) {
        return new DWQueryTimeoutQueryRunner(dataSourceProxy);
    }

    @Bean(name={"dw-sqlDialect"})
    @ConditionalOnMissingBean(value={DWSQLDialect.class})
    public DWSQLDialect dwSqlDialect(Environment environment) throws Exception {
        DWMySQLDialect dialect = null;
        String dialectClassName = environment.getProperty("dap.dwdao.default.dialect.class");
        if (dialectClassName == null) {
            dialect = new DWMySQLDialect();
        } else {
            Class<?> dialectClass = this.getClass().getClassLoader().loadClass(dialectClassName);
            dialect = (DWSQLDialect)dialectClass.newInstance();
        }
        return dialect;
    }

    @Primary
    @Bean(name={"dw-dao"})
    @ConditionalOnBean(name={"dw-queryRunner"})
    public DWDaoImpl dwDaoImpl(@Qualifier(value="dw-queryRunner") QueryRunner queryRunner, @Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties, @Qualifier(value="dw-sqlDialect") DWSQLDialect dialect, @Qualifier(value="dw-dao-properties") DWDaoProperties daoProperties) throws Exception {
        DWDaoImpl dao = new DWDaoImpl(queryRunner);
        dao.setDialect(dialect);
        dao.setProperties(daoProperties);
        boolean mapUnderscoreToCamelCase = true;
        boolean settingValue = dataSourceProperties.isDwDaoUnderScoreToCamelCase();
        if (!settingValue) {
            mapUnderscoreToCamelCase = false;
        }
        dao.setMapUnderscoreToCamelCase(mapUnderscoreToCamelCase);
        boolean insertDefaultValueFromMetadata = daoProperties.getDataSetProperties().isDwdaoInsertDefaultValueFromMetadata();
        dao.setInsertDefaultValueFromMetadata(insertDefaultValueFromMetadata);
        boolean updateDefaultValueFromMetadata = daoProperties.getDataSetProperties().isDwdaoUpdateDefaultValueFromMetadata();
        dao.setUpdateDefaultValueFromMetadata(updateDefaultValueFromMetadata);
        dao.setQueryPaginationByObjectEnabled(daoProperties.getDataSetProperties().isQueryPaginationByObjectEnabled());
        ArrayList<IDWResultSetFilter> resultSetFilters = new ArrayList<IDWResultSetFilter>();
        String resultSetFilterClassNames = daoProperties.getDaoResultSetFilterProperties().getResultSetFilterClassNames();
        if (resultSetFilterClassNames != null && !"".equals(resultSetFilterClassNames)) {
            String[] classNames;
            for (String className : classNames = resultSetFilterClassNames.split(",")) {
                Class resultSetFilterClass = DWApplicationClassLoader.getInstance().loadClass(className);
                resultSetFilters.add((IDWResultSetFilter)resultSetFilterClass.newInstance());
            }
        }
        DWResultSetFilterChain resultSetFilterChain = new DWResultSetFilterChain(resultSetFilters);
        dao.setDWResultSetFilter((IDWResultSetFilter)resultSetFilterChain);
        return dao;
    }

    @Bean(name={"dw-transactionManager"})
    @Primary
    @ConditionalOnBean(name={"dw-dataSource"})
    public DataSourceTransactionManager dataSourceTransactionManager(@Qualifier(value="dw-proxyDataSource") DataSource dataSourceProxy) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(dataSourceProxy);
        return dataSourceTransactionManager;
    }

    @Bean(name={"dw-fieldValueGeneratorFactory"})
    public DWFieldValueGeneratorFactory fieldValueGeneratorFactory() {
        DWFieldValueGeneratorFactory factory = new DWFieldValueGeneratorFactory();
        factory.addGenerator(DWFieldValueGeneratorEnum.UUID.getValue(), (IDWFieldValueGenerator)new DWUUIDValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.SQL_DATE.getValue(), (IDWFieldValueGenerator)new DWSQLDateValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.SQL_TIME.getValue(), (IDWFieldValueGenerator)new DWSQLTimeValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.SQL_TIMESTAMP.getValue(), (IDWFieldValueGenerator)new DWSQLTimestampValueGenerator());
        factory.addGenerator(DWFieldValueGeneratorEnum.TENANTSID.getValue(), (IDWFieldValueGenerator)new DWTenantsidValueGenerator());
        DWFieldValueGeneratorFactory.setInstance((DWFieldValueGeneratorFactory)factory);
        return factory;
    }
}

