/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.autoconfigure.condition.DWRedissonEnableCondition;
import com.digiwin.app.redisson.customize.DWRedissonAutoConfigurationCustomizer;
import com.digiwin.app.redisson.service.DWRedissonLockGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.api.RedissonClient;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.redisson.spring.starter.RedissonProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class, RedissonAutoConfiguration.class})
public class DWRedissonAutoConfiguration
extends RedissonAutoConfiguration {
    private static Log log = LogFactory.getLog(DWRedissonAutoConfiguration.class);

    @Bean(destroyMethod="shutdown")
    @Conditional(value={DWRedissonEnableCondition.class})
    public RedissonClient redisson(List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers) throws IOException {
        try {
            Field customize = DWRedissonAutoConfiguration.class.getSuperclass().getDeclaredField("redissonAutoConfigurationCustomizers");
            customize.setAccessible(true);
            customize.set((Object)this, redissonAutoConfigurationCustomizers);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error((Object)"unexpected error", (Throwable)e);
        }
        return super.redisson();
    }

    @Bean
    List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers(RedissonProperties redissonProperties) {
        ArrayList<RedissonAutoConfigurationCustomizer> config = new ArrayList<RedissonAutoConfigurationCustomizer>();
        DWRedissonAutoConfigurationCustomizer dwRedissonAutoConfigurationCustomizer = new DWRedissonAutoConfigurationCustomizer();
        dwRedissonAutoConfigurationCustomizer.setRedissonProperties(redissonProperties);
        config.add((RedissonAutoConfigurationCustomizer)dwRedissonAutoConfigurationCustomizer);
        return config;
    }

    @Bean(value={"dw-redisson"})
    @ConditionalOnBean(value={RedissonClient.class})
    public DWRedissonLockGenerator getDWRedissonLockGenerator(RedissonClient redissonClient, RedisTemplate redisTemplate) {
        return new DWRedissonLockGenerator(redissonClient, redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisTemplate"})
    @ConditionalOnBean(value={RedissonClient.class})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return super.redisTemplate(redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={StringRedisTemplate.class})
    @ConditionalOnBean(value={RedissonClient.class})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return super.stringRedisTemplate(redisConnectionFactory);
    }

    @Bean
    @ConditionalOnBean(value={RedissonClient.class})
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedissonConnectionFactory redissonConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }
}

