/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import com.digiwin.gateway.service.permission.config.DWServicePermissionConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWAPIPermissionEnableCondition
implements Condition {
    private static final String KEY_SUBSCRIPTION_PERMISSION_ON = "dap.subscription.permission.enable";
    private static final String KEY_API_PERMISSION_MODE = "dap.api.permission.mode";
    private static Log log = LogFactory.getLog(DWAPIPermissionEnableCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        int authorizationMode = DWAPIPermissionEnableCondition.getAuthorizationMode(context.getEnvironment());
        return DWServicePermissionConfig.isApiAuthorizationEnabled((int)authorizationMode);
    }

    public static int getAuthorizationMode(Environment environment) {
        String validSubscriptionPermissionString = environment.getProperty(KEY_SUBSCRIPTION_PERMISSION_ON);
        boolean validSubscriptionPermission = Boolean.parseBoolean(validSubscriptionPermissionString);
        String apiPermissionModeString = environment.getProperty(KEY_API_PERMISSION_MODE);
        int apiPermissionMode = -1;
        if (apiPermissionModeString == null && validSubscriptionPermission) {
            apiPermissionMode = 0;
            log.warn((Object)String.format("config:[%s] is deprecated, please use new config:[%s] instead!", KEY_SUBSCRIPTION_PERMISSION_ON, KEY_API_PERMISSION_MODE));
        } else if (apiPermissionModeString != null) {
            apiPermissionMode = Integer.parseInt(apiPermissionModeString);
        }
        return apiPermissionMode;
    }
}

