/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.ConfigurationClass;

public class DWConfigurationClassUtilities {
    private DWConfigurationClassUtilities() {
    }

    public static Map<String, Object> lookup(List<String> autoConfigNames, String ... configkeyWords) {
        LinkedHashMap<String, Object> lookupResult = new LinkedHashMap<String, Object>();
        List<Object> matchedConfigClassList = new ArrayList();
        LinkedHashMap keywordMappingMap = new LinkedHashMap();
        for (String keyWord : configkeyWords) {
            ArrayList<DWAutoConfigNameInfo> currentKeywordMappingList = new ArrayList<DWAutoConfigNameInfo>();
            keywordMappingMap.put(keyWord, currentKeywordMappingList);
            for (int i = 0; i < autoConfigNames.size(); ++i) {
                String autoConfigName = autoConfigNames.get(i);
                if (!autoConfigName.toLowerCase().contains(keyWord.toLowerCase())) continue;
                DWAutoConfigNameInfo info = new DWAutoConfigNameInfo(keyWord);
                info.index = i;
                info.name = autoConfigName;
                matchedConfigClassList.add(info);
                currentKeywordMappingList.add(info);
            }
        }
        matchedConfigClassList = matchedConfigClassList.stream().sorted(Comparator.comparingInt(o -> ((DWAutoConfigNameInfo)o).index)).collect(Collectors.toList());
        lookupResult.put("matched config classes", matchedConfigClassList);
        lookupResult.put("key words", keywordMappingMap);
        return lookupResult;
    }

    public static Map<String, Object> lookup(Collection<ConfigurationClass> configurationClasses, String ... configkeyWords) {
        LinkedHashMap<String, Object> lookupResult = new LinkedHashMap<String, Object>();
        List<Object> matchedConfigClassList = new ArrayList();
        ArrayList<ConfigurationClass> configurationClassList = new ArrayList<ConfigurationClass>(configurationClasses);
        LinkedHashMap keywordMappingMap = new LinkedHashMap();
        for (String keyWord : configkeyWords) {
            ArrayList<DWConfigClalssInfo> currentKeywordMappingList = new ArrayList<DWConfigClalssInfo>();
            keywordMappingMap.put(keyWord, currentKeywordMappingList);
            for (int i = 0; i < configurationClassList.size(); ++i) {
                ConfigurationClass configClass = (ConfigurationClass)configurationClassList.get(i);
                if (!configClass.getResource().toString().toLowerCase().contains(keyWord.toLowerCase())) continue;
                DWConfigClalssInfo info = new DWConfigClalssInfo(keyWord);
                info.index = i;
                info.resource = configClass.getResource().toString();
                info.configObject = configClass;
                matchedConfigClassList.add(info);
                currentKeywordMappingList.add(info);
            }
        }
        matchedConfigClassList = matchedConfigClassList.stream().sorted(Comparator.comparingInt(o -> ((DWConfigClalssInfo)o).index)).collect(Collectors.toList());
        lookupResult.put("matched config classes", matchedConfigClassList);
        lookupResult.put("key words", keywordMappingMap);
        return lookupResult;
    }

    public static class DWAutoConfigNameInfo {
        private int index = -1;
        private String name = null;
        private String keyWord;

        public String toString() {
            return "{index=" + this.index + ", name='" + this.name + '\'' + '}';
        }

        DWAutoConfigNameInfo(String keyWord) {
            this.keyWord = keyWord;
        }
    }

    public static class DWConfigClalssInfo {
        private int index = -1;
        private String keyWord;
        private String resource = "";
        private ConfigurationClass configObject = null;

        public String toString() {
            return "{index=" + this.index + ", resource='" + this.resource + '\'' + '}';
        }

        DWConfigClalssInfo(String keyWord) {
            this.keyWord = keyWord;
        }
    }
}

