/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.service.commons.config.DWServiceCommonsProperties;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.commons.utils.DWCommonsServiceUtil;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DWServiceCommonsProvider.class})
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
@ConditionalOnProperty(prefix="dap.service.commons.", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DWRestfulCommonsServiceAutoConfiguration {
    private static final String BEAN_DW_SERVICE_COMMONS_PROVIDER = "dw-service-commons-provider";

    @Bean(name={"dw-service-commons-properties"})
    public DWServiceCommonsProperties dwServiceCommonsProperties() {
        return new DWServiceCommonsProperties();
    }

    @Bean(value={"dw-service-commons-provider"})
    @ConditionalOnMissingBean(name={"dw-service-commons-provider"})
    public DWServiceCommonsProvider serviceCommonsProvider() {
        Map commonsInterfaces = DWCommonsServiceUtil.getCommonsServiceInterfaces();
        Map commonImplements = DWCommonsServiceUtil.getCommonsServiceImplements();
        return new DWServiceCommonsProvider(commonsInterfaces, commonImplements);
    }
}

