/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.merge;

import com.digiwin.app.autoconfigure.condition.DWEAIAutoRegistrationCondition;
import com.digiwin.app.autoconfigure.condition.DWMultipleAppEnvironmentCondition;
import com.digiwin.app.autoconfigure.condition.DWNotRunningFromIDECondition;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.merge.processor.DWSourceAppLoopProcessor;
import com.digiwin.app.merge.processor.DWSourceAppProcessContext;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@Conditional(value={DWMultipleAppEnvironmentCondition.class})
public class DWSourceAppAwareEAIRestfulUrlRegisterAutoConfiguration {
    private static Log log = LogFactory.getLog(DWSourceAppAwareEAIRestfulUrlRegisterAutoConfiguration.class);
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    private DWHttpClient httpClient;
    private DWEAIServiceAutoRegisterLoopProcessor autoRegisterLoopProcessor = new DWEAIServiceAutoRegisterLoopProcessor();

    @DependsOn(value={"dw-json-config"})
    @Bean(name={"DWEAIAutoRegistration"})
    @Conditional(value={DWEAIAutoRegistrationCondition.class, DWNotRunningFromIDECondition.class})
    public Object autoRegister(DWEAIProperties properties) throws Exception {
        log.info((Object)"Source APP aware - EAI Services start auto-registering...");
        DWEAIServiceAutoRegisterLoopProcessor processor = new DWEAIServiceAutoRegisterLoopProcessor();
        Map result = processor.process(this.eaiHeaderRepository.getAllHeader(), header -> DWSourceAppAwareUtils.getSourceAppId((String)header.getModuleName()));
        String response = result.entrySet().stream().map(entry -> (String)entry.getKey() + " - " + (String)entry.getValue()).collect(Collectors.joining(", " + System.lineSeparator()));
        return response;
    }

    public class DWEAIServiceAutoRegisterLoopProcessor
    extends DWSourceAppLoopProcessor<DWHeader, String> {
        protected void beforeUnitProcess(DWSourceAppProcessContext<DWHeader, String> context) {
            log.info((Object)String.format("APP(id = %s) eai service auto-registering...", context.getAppId()));
        }

        public String unitProcess(String appId, List<DWHeader> data) {
            String responseBody = "";
            try {
                DWEAIProperties properties = DWEAIProperties.getProperties();
                Map result = EaiInfoUtils.getSrvRegInfo(() -> data.stream().map(h -> ((DWEAIHeader)h).getEAIServiceId()).collect(Collectors.toList()), (DWEAIProperties)properties);
                HttpPost post = new HttpPost(EaiInfoUtils.getEAIRegSrvURL());
                post.setEntity((HttpEntity)new DWJsonEntity((Object)result));
                EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
                post.addHeader("digi-action", "reg");
                HttpResponse response = DWSourceAppAwareEAIRestfulUrlRegisterAutoConfiguration.this.httpClient.execute((HttpUriRequest)post, new DWRequestOption(false));
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    log.error((Object)"Something wrong in the process of eai services auto-registration...");
                    log.error((Object)responseBody);
                } else {
                    responseBody = "done!";
                    log.info((Object)String.format("Source APP aware - APP(id = %s) EAI Services have registered automatically.", appId));
                }
            }
            catch (Exception e) {
                responseBody = "exception! message=" + e.getMessage();
                log.error((Object)String.format("Source APP aware - APP(id = %s) EAI Services auto register failed!", appId), (Throwable)e);
            }
            return responseBody;
        }

        public void summary(Map processHistory) {
        }
    }
}

