/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DWAutoConfigurationManagementImportFilter
implements AutoConfigurationImportFilter,
EnvironmentAware {
    private List<String> excludeAutoConfigurations = new ArrayList<String>();

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        boolean[] matches = new boolean[autoConfigurationClasses.length];
        for (int i = 0; i < autoConfigurationClasses.length; ++i) {
            matches[i] = !this.excludeAutoConfigurations.contains(autoConfigurationClasses[i]);
        }
        return matches;
    }

    public void setEnvironment(Environment environment) {
        String springRabbitHost;
        boolean removeRedisHealthIndicator;
        String springDbUrl = environment.getProperty("spring.datasource.url");
        if (springDbUrl == null || springDbUrl.isEmpty()) {
            this.excludeAutoConfigurations.add("com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure");
        }
        String springRedisUrl = environment.getProperty("spring.redis.url");
        String springRedisHost = environment.getProperty("spring.redis.host");
        boolean bl = removeRedisHealthIndicator = !(springRedisUrl != null && !springRedisUrl.isEmpty() || springRedisHost != null && !springRedisHost.isEmpty());
        if (removeRedisHealthIndicator) {
            this.excludeAutoConfigurations.add("org.springframework.boot.actuate.autoconfigure.redis.RedisHealthIndicatorAutoConfiguration");
            this.excludeAutoConfigurations.add("com.digiwin.app.autoconfigure.DWRedisAutoConfiguration");
            this.excludeAutoConfigurations.add("org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration");
        }
        if ((springRabbitHost = environment.getProperty("spring.rabbitmq.host")) == null || springRabbitHost.isEmpty()) {
            this.excludeAutoConfigurations.add("org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration");
        }
        this.excludeAutoConfigurations.add("org.redisson.spring.starter.RedissonAutoConfiguration");
    }
}

