/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.dao.filter.DWFieldValueFilter;
import com.digiwin.app.dao.filter.DWSQLFilterChain;
import com.digiwin.app.dao.filter.DWSQLInjectionCheckFilter;
import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.dao.filter.DWSQLTenantIsolationFilter;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWDataSetInsertOption;
import com.digiwin.app.data.generator.DWSnowFlakeValueGenerator;
import com.digiwin.app.data.generator.IDWFieldValueGenerator;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@DependsOn(value={"dw-dao-properties"})
public class DWSQLFilterChainAutoConfiguration {
    @Bean(value={"fixedFieldValueGeneratorSettings"})
    @ConditionalOnProperty(value={"dw.dao.fixed.field.value.generator.enabled"}, havingValue="true", matchIfMissing=false)
    public List<DWDataSetInsertOption.DWFieldValueGeneratorSetting> getDWFieldValueGeneratorSetting() {
        ArrayList<DWDataSetInsertOption.DWFieldValueGeneratorSetting> list = new ArrayList<DWDataSetInsertOption.DWFieldValueGeneratorSetting>();
        list.add(new DWDataSetInsertOption.DWFieldValueGeneratorSetting("${primaryKey}", (IDWFieldValueGenerator)new DWSnowFlakeValueGenerator()));
        return list;
    }

    @Bean(value={"dw-sqlFilterChain"})
    @DependsOn(value={"tenantAutoConfiguration"})
    public DWSQLFilterChain getSQLFilterChain(Environment environment, @Autowired(required=false) List<DWDataSetInsertOption.DWFieldValueGeneratorSetting> settings) throws Exception {
        List<IDWSQLFilter> filters = this.getCustomFilters();
        if (filters == null) {
            DWSQLManagementFieldFilter filter;
            filters = new ArrayList<IDWSQLFilter>();
            if (DWSQLManagementFieldFilter.isEnabled()) {
                filter = DWSQLFilterChainAutoConfiguration.getDefaultMgmtFieldSQLFilter();
                filters.add((IDWSQLFilter)filter);
            }
            filter = new DWSQLTenantIsolationFilter();
            filters.add((IDWSQLFilter)filter);
            DWSQLInjectionCheckFilter dwsqlInjectionCheckFilter = new DWSQLInjectionCheckFilter();
            dwsqlInjectionCheckFilter.setCheckSqlInjection(((Boolean)environment.getProperty("dap.dwdao.query.check-sql-injection", Boolean.class, (Object)true)).booleanValue());
            filters.add((IDWSQLFilter)dwsqlInjectionCheckFilter);
            DWFieldValueFilter dwFieldValueFilter = new DWFieldValueFilter();
            dwFieldValueFilter.setFixedFieldValueGeneratorSettings(settings);
            filters.add((IDWSQLFilter)dwFieldValueFilter);
            IDWSQLFilter dataPermSqlFilter = DWSQLFilterChainAutoConfiguration.getDataPermissionSQLFilter();
            if (dataPermSqlFilter != null) {
                filters.add(dataPermSqlFilter);
            }
        }
        return new DWSQLFilterChain(filters);
    }

    private static IDWManagementFieldResolver getResolver() throws Exception {
        String mgmtFieldResolverClazz = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().getMgmtFieldResolver();
        Class resolverClass = DWApplicationClassLoader.getInstance().loadClass(mgmtFieldResolverClazz);
        return (IDWManagementFieldResolver)resolverClass.newInstance();
    }

    private static DWSQLManagementFieldFilter getDefaultMgmtFieldSQLFilter() throws Exception {
        IDWManagementFieldResolver resolver = DWSQLFilterChainAutoConfiguration.getResolver();
        return new DWSQLManagementFieldFilter(resolver);
    }

    private static IDWSQLFilter getDataPermissionSQLFilter() throws Exception {
        IDWSQLFilter result = null;
        String dataPermSqlFilterClassName = DWDaoProperties.getDefaultProperties().getDaoSqlFilterProperties().getDataPermSqlFilter();
        if (dataPermSqlFilterClassName != null) {
            Class dataPermSqlFilterClass = DWApplicationClassLoader.getInstance().loadClass(dataPermSqlFilterClassName);
            result = (IDWSQLFilter)dataPermSqlFilterClass.newInstance();
        }
        return result;
    }

    private List<IDWSQLFilter> getCustomFilters() throws Exception {
        ArrayList<DWSQLManagementFieldFilter> customFilters = null;
        String dwsqlFilterChianCustom = DWDaoProperties.getDefaultProperties().getDaoSqlFilterProperties().getDwsqlFilterChianCustom();
        if (dwsqlFilterChianCustom != null && dwsqlFilterChianCustom.toLowerCase().startsWith("true:")) {
            String[] parts;
            customFilters = new ArrayList<DWSQLManagementFieldFilter>();
            String customFiltersString = dwsqlFilterChianCustom.substring("true:".length());
            for (String clazzString : parts = customFiltersString.split(",")) {
                Class clazz = DWApplicationClassLoader.getInstance().loadClass(clazzString);
                Object instance = clazz == DWSQLManagementFieldFilter.class ? DWSQLFilterChainAutoConfiguration.getDefaultMgmtFieldSQLFilter() : (IDWSQLFilter)clazz.newInstance();
                customFilters.add((DWSQLManagementFieldFilter)instance);
            }
        }
        return customFilters;
    }
}

