/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWDbEnableCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean isDbEnabled = DWDbEnableCondition.isDbEnabled(context.getEnvironment());
        boolean isDbUrlEmpty = DWDbEnableCondition.isDbUrlEmpty(context.getEnvironment());
        return isDbEnabled && !isDbUrlEmpty;
    }

    public static boolean isDbEnabled(Environment environment) {
        String scheduleEnabled = environment.getProperty("dbEnabled");
        boolean isDbUrlEmpty = DWDbEnableCondition.isDbUrlEmpty(environment);
        return "true".equalsIgnoreCase(scheduleEnabled) && !isDbUrlEmpty;
    }

    public static boolean isDbUrlEmpty(Environment environment) {
        String dbUrl = environment.getProperty("dbUrl");
        return dbUrl == null || dbUrl.trim().equals("");
    }
}

