/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.iam;

import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.IAMCommonService;
import com.digiwin.iam.IAMFuncPermissionService;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.IAMIdentityService;
import com.digiwin.iam.IAMUserAllInfoService;
import com.digiwin.iam.IAMUserInfoService;
import com.digiwin.iam.IAMUserService;
import com.digiwin.iam.UserTokenService;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={IAMHttpRequester.class})
@AutoConfigureOrder(value=-2147483648)
public class DWIAMAutoConfiguration {
    @Bean(value={"dw-iam-properties"})
    public DWIAMProperties getProperties(Environment environment) {
        DWIAMProperties properties = new DWIAMProperties();
        properties.setUrl(environment.getProperty("iamUrl"));
        properties.setContentType(environment.getProperty("iamContentType"));
        properties.setCharset(environment.getProperty("iamCharset"));
        properties.setConnectionRequestTimeout(Integer.parseInt(environment.getProperty("iamHttpConnectionPoolRequestTimeout")));
        properties.setConnectionTimeout(Integer.parseInt(environment.getProperty("iamHttpConnectionTimeout")));
        properties.setRequestSocketTimeout(Integer.parseInt(environment.getProperty("iamSoTimeout")));
        properties.setEncode(environment.getProperty("iamEncode"));
        properties.setConnectionMaxTotal(Integer.parseInt(environment.getProperty("iamHttpMaxConnections")));
        properties.setKeepAliveTimeout(Long.parseLong(environment.getProperty("iamKeepAliveTimeout")));
        properties.setAppToken(environment.getProperty("iamApToken", ""));
        String serverTokenMode = environment.getProperty("serverHttpTokenmode", "");
        properties.setIAMTokenMode(serverTokenMode.equals("IAM"));
        properties.setApiPathUserBasicInfo(environment.getProperty("iamUrlUser"));
        properties.setApiPathLogin(environment.getProperty("iamUrlLogin"));
        properties.setApiPathUserTokenAnalyze(environment.getProperty("iamUrlUsertokenAnalyze"));
        properties.setApiPathUserAllInfo(environment.getProperty("iamUrlUserAllInfo"));
        properties.setApiPathUserTenantApplication(environment.getProperty("iamUrlUserTenantApplication"));
        properties.setApiPathIntegrationUserLogin(environment.getProperty("iamUrlIntegrationUserLogin", "/api/iam/v2/identity/login/internal"));
        properties.setIntegrationUserId(environment.getProperty("iamIntegrationUserId", "integration"));
        properties.setIntegrationUserPasswordHash(environment.getProperty("iamIntegrationUserPasswordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B"));
        IAMHttpRequester.setProperties((DWIAMProperties)properties);
        return properties;
    }

    @Configuration
    @DependsOn(value={"dw-iam-properties"})
    static class DWIAMServiceConfiguration {
        DWIAMServiceConfiguration() {
        }

        @Bean(name={"dwUserTokenService"})
        public UserTokenService userTokenService() {
            return new UserTokenService();
        }

        @Bean(name={"dwIAMFuncPermissionService"})
        public IAMFuncPermissionService funcPermissionService() {
            return new IAMFuncPermissionService();
        }

        @Bean(name={"dwIAMUserService"})
        public IAMUserService userService() {
            return new IAMUserService();
        }

        @Bean(name={"dwIAMIdentityService"})
        public IAMIdentityService identityService() {
            return new IAMIdentityService();
        }

        @Bean(name={"dwIAMCommonService"})
        public IAMCommonService iamCommonService() {
            return new IAMCommonService();
        }

        @Bean(name={"dwIAMUserInfoService"})
        public IAMUserInfoService userInfoService() {
            return new IAMUserInfoService();
        }

        @Bean(name={"dwIAMUserAllInfoService"})
        public IAMUserAllInfoService userAllInfoService() {
            return new IAMUserAllInfoService();
        }
    }
}

