/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.server;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.digiwin.gateway.server.DWTomcat;
import com.digiwin.gateway.server.DWTomcatProperties;
import com.digiwin.gateway.server.DWUndertow;
import com.digiwin.gateway.server.DWUndertowProperties;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class DWServerAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"serverType"}, havingValue="tomcat", matchIfMissing=true)
    public ServletWebServerFactory tomcatServletContainer(Environment environment) {
        String relaxedQueryChars;
        String relaxedPathChars;
        String maxThreads;
        String minSpareThreads;
        String maxConnections;
        String acceptCount;
        DWTomcatProperties properties = new DWTomcatProperties();
        String port = environment.getProperty("serverPort");
        if (port != null) {
            properties.setPort(port);
        }
        if ((acceptCount = environment.getProperty("serverTomcatAcceptCount")) != null) {
            properties.setAcceptCount(acceptCount);
        }
        if ((maxConnections = environment.getProperty("serverTomcatMaxConnections")) != null) {
            properties.setMaxConnections(maxConnections);
        }
        if ((minSpareThreads = environment.getProperty("serverTomcatMinSpareThreads")) != null) {
            properties.setMinSpareThreads(minSpareThreads);
        }
        if ((maxThreads = environment.getProperty("serverTomcatMaxThreads")) != null) {
            properties.setMaxThreads(maxThreads);
        }
        if ((relaxedPathChars = environment.getProperty("relaxedPathChars")) != null) {
            properties.setRelaxedPathChars(relaxedPathChars);
        }
        if ((relaxedQueryChars = environment.getProperty("relaxedQueryChars")) != null) {
            properties.setRelaxedQueryChars(relaxedQueryChars);
        }
        return new DWTomcat(properties);
    }

    @Bean
    @ConditionalOnProperty(name={"serverType"}, havingValue="undertow")
    public ServletWebServerFactory undertowServletContainer(Environment environment) {
        String workerThreads;
        String ioThreads;
        DWUndertowProperties properties = new DWUndertowProperties();
        String port = environment.getProperty("serverPort");
        if (port != null) {
            properties.setPort(Integer.valueOf(port).intValue());
        }
        if ((ioThreads = environment.getProperty("server.undertow.io-threads")) != null) {
            properties.setIoThreads(Integer.valueOf(ioThreads).intValue());
        }
        if ((workerThreads = environment.getProperty("server.undertow.worker-threads")) != null) {
            properties.setWorkerThreads(Integer.valueOf(workerThreads).intValue());
        }
        return new DWUndertow(properties);
    }

    @Configuration
    private static class InnerTestConfiguration {
        private static Log log = LogFactory.getLog(InnerTestConfiguration.class);

        public InnerTestConfiguration(ServletWebServerFactory servletWebServerFactory) {
            log.info("GC information>ServletWebServerFactory type: " + servletWebServerFactory.getClass());
        }
    }
}

