/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWEAIAutoRegistrationCondition;
import com.digiwin.app.autoconfigure.condition.DWNotRunningFromIDECondition;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.gateway.controller.EaiController;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.gateway.controller.EaiNioController;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class DWEAIRestfulUrlRegisterAutoConfiguration {
    private static Log log = LogFactory.getLog(DWEAIRestfulUrlRegisterAutoConfiguration.class);
    private static final String KEY_EAI_CONTROLLER = "eaiController";
    private static final String KEY_EAI_NIO_CONTROLLER = "eaiNioController";
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    private DWHttpClient httpClient;

    @DependsOn(value={"dw-json-config"})
    @Bean(name={"DWEAIAutoRegistration"})
    @ConditionalOnMissingBean(name={"DWEAIAutoRegistration"})
    @Conditional(value={DWEAIAutoRegistrationCondition.class, DWNotRunningFromIDECondition.class})
    public Object autoRegister(DWEAIProperties properties) throws Exception {
        Map result = new HashMap();
        log.info((Object)"EAI Services start auto-registering...");
        result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList(), (DWEAIProperties)properties);
        HttpPost post = new HttpPost(EaiInfoUtils.getEAIRegSrvURL());
        post.setEntity((HttpEntity)new DWJsonEntity(result));
        EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
        post.addHeader("digi-action", "reg");
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)post, new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error((Object)"Something wrong in the process of eai services auto-registration...");
                log.error((Object)EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
            } else {
                log.info((Object)"EAI Services have rigistered automatically.");
            }
        }
        catch (Exception e) {
            log.error((Object)"eai auto register failed!", (Throwable)e);
        }
        return response;
    }

    static class BioConfiguration {
        BioConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"serverHttpControllerIo"}, havingValue="bio")
        public EaiController eaiController(RequestMappingHandlerMapping requestMappingHandlerMapping, DWEAIProperties properties) throws Exception {
            EaiController controller = new EaiController();
            RequestMappingInfo eaiRestfulMappingInfo = RequestMappingInfo.paths((String[])new String[]{properties.getRestfulServicePath()}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json"}).build();
            requestMappingHandlerMapping.registerMapping(eaiRestfulMappingInfo, (Object)DWEAIRestfulUrlRegisterAutoConfiguration.KEY_EAI_CONTROLLER, EaiController.class.getDeclaredMethod("eai", new Class[0]));
            RequestMappingInfo eaiCallbackMappingInfo = RequestMappingInfo.paths((String[])new String[]{properties.getRestfulServiceCallbackPath()}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json"}).build();
            requestMappingHandlerMapping.registerMapping(eaiCallbackMappingInfo, (Object)DWEAIRestfulUrlRegisterAutoConfiguration.KEY_EAI_CONTROLLER, EaiController.class.getDeclaredMethod("callback", new Class[0]));
            RequestMappingInfo eaiSyncProdMappingInfo = RequestMappingInfo.paths((String[])new String[]{properties.getRestfulServiceSyncProdPath()}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json"}).build();
            requestMappingHandlerMapping.registerMapping(eaiSyncProdMappingInfo, (Object)DWEAIRestfulUrlRegisterAutoConfiguration.KEY_EAI_CONTROLLER, EaiController.class.getDeclaredMethod("syncProd", new Class[0]));
            return controller;
        }

        @Bean
        @ConditionalOnProperty(name={"serverHttpControllerIo"}, havingValue="nio", matchIfMissing=true)
        public EaiNioController eaiNioController(RequestMappingHandlerMapping requestMappingHandlerMapping, DWEAIProperties properties) throws Exception {
            EaiNioController controller = new EaiNioController();
            RequestMappingInfo eaiRestfulMappingInfo = RequestMappingInfo.paths((String[])new String[]{properties.getRestfulServicePath()}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json"}).build();
            requestMappingHandlerMapping.registerMapping(eaiRestfulMappingInfo, (Object)DWEAIRestfulUrlRegisterAutoConfiguration.KEY_EAI_NIO_CONTROLLER, EaiNioController.class.getDeclaredMethod("eai", new Class[0]));
            RequestMappingInfo eaiCallbackMappingInfo = RequestMappingInfo.paths((String[])new String[]{properties.getRestfulServiceCallbackPath()}).methods(new RequestMethod[]{RequestMethod.POST}).build();
            requestMappingHandlerMapping.registerMapping(eaiCallbackMappingInfo, (Object)DWEAIRestfulUrlRegisterAutoConfiguration.KEY_EAI_NIO_CONTROLLER, EaiNioController.class.getDeclaredMethod("callback", new Class[0]));
            RequestMappingInfo eaiSyncProdMappingInfo = RequestMappingInfo.paths((String[])new String[]{properties.getRestfulServiceSyncProdPath()}).methods(new RequestMethod[]{RequestMethod.POST}).build();
            requestMappingHandlerMapping.registerMapping(eaiSyncProdMappingInfo, (Object)DWEAIRestfulUrlRegisterAutoConfiguration.KEY_EAI_NIO_CONTROLLER, EaiNioController.class.getDeclaredMethod("syncProd", new Class[0]));
            return controller;
        }
    }
}

