/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.servicechain.ex;

import com.digiwin.app.autoconfigure.condition.DWServiceChainAutoAttachHeaderEnableCondition;
import com.digiwin.app.service.DWServiceChainDataProviderManager;
import com.digiwin.app.service.callback.DWServiceChainDataProvider;
import com.digiwin.app.service.callback.DWServiceChainDefaultHeaderProvider;
import com.digiwin.app.service.callback.amqp.DWAttachSpringAmqpMessageHeadersCallback;
import com.digiwin.app.service.callback.http.DWAttachHttpHeadersCallback;
import com.digiwin.app.service.interceptor.DWServiceChainExecutorBaseInterceptor;
import com.digiwin.app.service.processor.amqp.ex.DWAttachRabbitTemplateMessageHeadersPostProcessor;
import com.digiwin.app.service.processor.amqp.ex.DWRabbitListenerContainerReceiverBeanProcessor;
import com.digiwin.app.service.processor.amqp.ex.DWRabbitTemplateExecutorBeanProcessor;
import com.digiwin.app.service.processor.amqp.ex.DWReceiveSpringAmqpMessageHeadersPostProcessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={DWServiceChainAutoAttachHeaderEnableCondition.class})
public class DWServiceChainExecutorAutoConfiguration {
    @Bean(value={"dw-httpclient-executor-aop"})
    public DefaultPointcutAdvisor dwHttpClientInterceptor(ObjectProvider<List<DWAttachHttpHeadersCallback>> listObjectProvider) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.apache.http.client.HttpClient+) && execution(public org.apache.http.HttpResponse execute(..))");
        List callbackList = (List)listObjectProvider.getIfAvailable(Collections::emptyList);
        DWServiceChainExecutorBaseInterceptor<HttpUriRequest, DWAttachHttpHeadersCallback> httpUriRequestInterceptor = new DWServiceChainExecutorBaseInterceptor<HttpUriRequest, DWAttachHttpHeadersCallback>(callbackList){};
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)httpUriRequestInterceptor);
        return advisor;
    }

    @Bean(value={"digi-service-chain-data-provider-Manager"})
    public DWServiceChainDataProviderManager dwServiceChainDataProviderManager(Environment environment) {
        DWServiceChainDataProviderManager manager = new DWServiceChainDataProviderManager();
        String defaultAttachHeaders = environment.getProperty("dap.service-chain.auto-attach.headers", "digi-json-view");
        HashSet dataProviders = new HashSet();
        if (defaultAttachHeaders != null && !defaultAttachHeaders.isEmpty()) {
            String[] elements;
            for (String key : elements = defaultAttachHeaders.split(",")) {
                manager.register((DWServiceChainDataProvider)new DWServiceChainDefaultHeaderProvider(key));
            }
        }
        return manager;
    }

    @Bean(value={"dw-attach-http-headers-callback"})
    public DWAttachHttpHeadersCallback dwAttachHttpHeadersCallback(DWServiceChainDataProviderManager serviceChainDataProviderManager) {
        return new DWAttachHttpHeadersCallback(serviceChainDataProviderManager.getDataProviders());
    }

    @Bean(value={"dw-attach-spring-amqp-headers-callback"})
    public DWAttachSpringAmqpMessageHeadersCallback dwAttachSpringAmqpMessageHeadersCallback(DWServiceChainDataProviderManager serviceChainDataProviderManager) {
        return new DWAttachSpringAmqpMessageHeadersCallback(serviceChainDataProviderManager.getDataProviders());
    }

    @Bean(value={"dw-attach-rabbit-template-message-headers-post-processor"})
    public DWAttachRabbitTemplateMessageHeadersPostProcessor attachRabbitTemplateMessageHeadersPostProcessor(ObjectProvider<List<DWAttachSpringAmqpMessageHeadersCallback>> callbackListProvider) {
        List callbackList = (List)callbackListProvider.getIfAvailable(Collections::emptyList);
        return new DWAttachRabbitTemplateMessageHeadersPostProcessor(callbackList);
    }

    @Bean(value={"dw-rabbit-template-executor-bean-processor"})
    public static DWRabbitTemplateExecutorBeanProcessor dwRabbitTemplateExecutorBeanProcessor(DWAttachRabbitTemplateMessageHeadersPostProcessor beforePublishPostProcessor, DWReceiveSpringAmqpMessageHeadersPostProcessor afterReceivePostProcessor) {
        return new DWRabbitTemplateExecutorBeanProcessor(beforePublishPostProcessor, afterReceivePostProcessor);
    }

    @Bean(value={"dw-rabbit-listener-container-receiver-bean-processor"})
    public DWRabbitListenerContainerReceiverBeanProcessor rabbitListenerContainerReceiverBeanProcessor(DWReceiveSpringAmqpMessageHeadersPostProcessor afterReceivePostProcessor) {
        return new DWRabbitListenerContainerReceiverBeanProcessor(afterReceivePostProcessor);
    }
}

