/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.servicechain;

import com.digiwin.app.autoconfigure.condition.DWServiceChainEnableCondition;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.service.processor.DWInvokerBeanContainerBeanProcessor;
import com.digiwin.app.service.processor.DWInvokerBeanProcessor;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWServiceChainAutoConfiguration {
    public DWServiceChainAutoConfiguration() {
        DWModuleSpringUtils.registerModuleConfigurationClass(DWServiceChainAutoConfiguration.class);
    }

    @Bean(value={"DWInvokerBeanDefaultProcessor"})
    public static DWInvokerBeanContainerBeanProcessor getDWInvokerBeanDefaultProcessor(Environment environment, ObjectProvider<List<DWInvokerBeanProcessor>> invokerBeanProcessorListProvider) {
        if (DWServiceChainEnableCondition.isEnabled()) {
            String customId = environment.getProperty("dwServiceChainCustomId", "");
            if (customId != null && !customId.isEmpty() && !customId.equals("@dwServiceChainCustomId@")) {
                DWServiceChainUtils.setIdentity((String)customId);
            } else {
                DWServiceChainUtils.setIdentity((String)environment.getProperty("appId", ""));
            }
            DWServiceChainUtils.setPrinterType((String)environment.getProperty("dwServiceChainReceivedPrinterType", ""));
        }
        DWInvokerBeanContainerBeanProcessor beanProcessor = new DWInvokerBeanContainerBeanProcessor();
        List invokerBeanProcessorList = (List)invokerBeanProcessorListProvider.getIfAvailable();
        if (invokerBeanProcessorList != null) {
            invokerBeanProcessorList.forEach(ib -> beanProcessor.registerProcessor(ib));
        }
        return beanProcessor;
    }
}

