/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.module;

import com.digiwin.app.autoconfigure.condition.DWModularModeCondition;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={DWModularModeCondition.class})
public class DWStartupAutoLoadModulesAutoConfiguration {
    private static Log log = LogFactory.getLog(DWStartupAutoLoadModulesAutoConfiguration.class);

    public DWStartupAutoLoadModulesAutoConfiguration(Environment environment, DWContainerContext containerContext) {
        LinkedHashSet<String> moduleSet;
        String autoLoadConfig = environment.getProperty("dap.modules.auto-load-on-startup");
        if (autoLoadConfig == null || !autoLoadConfig.toLowerCase().equals("true") && !autoLoadConfig.toLowerCase().startsWith("true:")) {
            return;
        }
        LinkedHashSet<String> allModuleSet = new LinkedHashSet<String>();
        allModuleSet.addAll(DWModuleSpringUtils.getModuleNameList());
        LinkedHashSet<String> invalidModuleSet = new LinkedHashSet<String>();
        if (autoLoadConfig.toLowerCase().equals("true")) {
            moduleSet = allModuleSet;
        } else {
            String[] parts = autoLoadConfig.substring("true:".length()).split(",");
            TreeSet noneAsteriskModule = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            noneAsteriskModule.addAll(Arrays.stream(parts).filter(s -> !"*".equals(s)).collect(Collectors.toSet()));
            Set asteriskSubstituteSet = allModuleSet.stream().filter(m -> !noneAsteriskModule.contains(m)).collect(Collectors.toCollection(LinkedHashSet::new));
            moduleSet = new LinkedHashSet();
            for (String part : parts) {
                if ("*".equals(part)) {
                    moduleSet.addAll(asteriskSubstituteSet);
                    continue;
                }
                if (allModuleSet.stream().anyMatch(m -> part.trim().equalsIgnoreCase((String)m))) {
                    moduleSet.add(allModuleSet.stream().filter(m -> part.trim().equalsIgnoreCase((String)m)).findFirst().get());
                    continue;
                }
                invalidModuleSet.add(part);
            }
        }
        log.info((Object)"...auto load modules on startup!");
        int loadSeq = 1;
        List<Object> moduleLoadInfoList = new ArrayList<ModuleLoadInfo>();
        for (String moduleName : moduleSet) {
            StopWatch watch = StopWatch.createStarted();
            log.info((Object)String.format("...>>> auto loading module(name=%s)...", moduleName, watch.getTime()));
            DWModuleSpringUtils.getModuleSpringContext((String)moduleName);
            watch.stop();
            moduleLoadInfoList.add(new ModuleLoadInfo(loadSeq++, moduleName, watch.getTime()));
        }
        moduleLoadInfoList.sort(Comparator.comparingLong(rec$ -> ((ModuleLoadInfo)rec$).getTime()).reversed());
        moduleLoadInfoList = moduleLoadInfoList.stream().sorted(Comparator.comparingLong(rec$ -> ((ModuleLoadInfo)rec$).getTime()).reversed()).collect(Collectors.toList());
        long totalTime = moduleLoadInfoList.stream().mapToLong(m -> ((ModuleLoadInfo)m).getTime()).sum();
        log.info((Object)"---------- Module Loading Time ----------");
        moduleLoadInfoList.stream().forEach(mi -> log.info((Object)String.format("\ttime: %s(ms)......[%s.%s]", ((ModuleLoadInfo)mi).getTime(), ((ModuleLoadInfo)mi).seq, ((ModuleLoadInfo)mi).name)));
        log.info((Object)"--------------- Summarize ---------------");
        log.info((Object)String.format("\t\tauto loading modules: %s", moduleSet));
        log.info((Object)String.format("\t\tinvalid modules: %s", invalidModuleSet));
        log.info((Object)String.format("\t\ttotal time: %s(ms)", totalTime));
        log.info((Object)"-----------------------------------------");
    }

    private static class ModuleLoadInfo {
        private int seq;
        private String name;
        private long time;

        private ModuleLoadInfo(int seq, String name, long time) {
            this.seq = seq;
            this.name = name;
            this.time = time;
        }

        private long getTime() {
            return this.time;
        }
    }
}

