/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.log;

import com.digiwin.app.autoconfigure.log.DWConditionalOnEnabledDwLog;
import com.digiwin.app.service.interceptor.DWServiceChainExecutorBaseInterceptor;
import com.digiwin.app.service.interceptor.log.DWDbLogMehodInterceptor;
import com.digiwin.app.service.interceptor.log.DWHttpClientLogCallback;
import com.digiwin.app.service.interceptor.log.DWMongoTemplateInterceptor;
import com.digiwin.app.service.interceptor.log.DWRabbitmqConsumerLogInterceptor;
import com.digiwin.app.service.interceptor.log.DWRabbitmqProducerLogInterceptor;
import com.digiwin.app.service.interceptor.log.DWRedisLogMehodInterceptor;
import java.util.Collections;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.http.HttpRequest;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWLogAutoConfiguration {
    @Autowired
    private Environment environment;

    @Bean(value={"dw-httpclient-lpg-aop"})
    @DWConditionalOnEnabledDwLog(value="httpclient")
    public DefaultPointcutAdvisor dwHttpClientLogInterceptor(ObjectProvider<List<DWHttpClientLogCallback>> listObjectProvider) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.apache.http.client.HttpClient+) && execution(public org.apache.http.HttpResponse execute(..))");
        List callbackList = (List)listObjectProvider.getIfAvailable(Collections::emptyList);
        DWServiceChainExecutorBaseInterceptor<HttpRequest, DWHttpClientLogCallback> httpUriRequestInterceptor = new DWServiceChainExecutorBaseInterceptor<HttpRequest, DWHttpClientLogCallback>(callbackList){};
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)httpUriRequestInterceptor);
        return advisor;
    }

    @Bean(value={"dw-http-client-log-callback"})
    @DWConditionalOnEnabledDwLog(value="httpclient")
    public DWHttpClientLogCallback dwHttpClientLogCallback() {
        return new DWHttpClientLogCallback(this.environment);
    }

    @Bean(value={"dw-query-runner-log"})
    @DWConditionalOnEnabledDwLog(value="db")
    public DefaultPointcutAdvisor dwQueryRunnerInterceptor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* org.apache.commons.dbutils.DWQueryTimeoutQueryRunner.*(..))");
        DWDbLogMehodInterceptor dWDbLogMehodInterceptor = new DWDbLogMehodInterceptor(this.environment){};
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dWDbLogMehodInterceptor);
        return advisor;
    }

    @Bean(value={"dw-redis-service-log"})
    @DWConditionalOnEnabledDwLog(value="redis")
    public DefaultPointcutAdvisor dwRedisInterceptor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* com.digiwin.app.redis.service.DefaultRedisService.*(..)) || execution(* com.digiwin.app.redis.service.DefaultPipielineService.*(..))");
        DWRedisLogMehodInterceptor dWRedisLogMehodInterceptor = new DWRedisLogMehodInterceptor(this.environment){};
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dWRedisLogMehodInterceptor);
        return advisor;
    }

    @Bean(value={"dw-mongodb-template-log"})
    @DWConditionalOnEnabledDwLog(value="mongdb")
    public DefaultPointcutAdvisor dwMongodbInterceptor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* org.springframework.data.mongodb.core.MongoTemplate.*(..))");
        DWMongoTemplateInterceptor dwMongoTemplateInterceptor = new DWMongoTemplateInterceptor(this.environment){};
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dwMongoTemplateInterceptor);
        return advisor;
    }

    @Bean(value={"dw-rabbitmq-consumer-log"})
    @DWConditionalOnEnabledDwLog(value="rabbitmq-consumer")
    public DefaultPointcutAdvisor dwRabbitmqConsumerLogInterceptor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.springframework.amqp.core.MessageListener+) && execution(public * onMessage(org.springframework.amqp.core.Message, ..)) || @annotation(org.springframework.amqp.rabbit.annotation.RabbitListener)");
        DWRabbitmqConsumerLogInterceptor interceptor = new DWRabbitmqConsumerLogInterceptor(this.environment);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }

    @Bean(value={"dw-rabbitmq-producer-log"})
    @DWConditionalOnEnabledDwLog(value="rabbitmq-producer")
    public DefaultPointcutAdvisor dwRabbitmqRroducerInterceptor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* org.springframework.amqp.rabbit.core.RabbitTemplate.*(..))");
        DWRabbitmqProducerLogInterceptor interceptor = new DWRabbitmqProducerLogInterceptor(this.environment){};
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }
}

