/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.log;

import com.digiwin.app.autoconfigure.log.DWConditionalOnEnabledDwLog;
import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWOnEnabledDwLogCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        Map attributes = metadata.getAnnotationAttributes(DWConditionalOnEnabledDwLog.class.getName());
        String featureName = (String)attributes.get("value");
        return this.isFeatureEnabled(environment, featureName);
    }

    private boolean isFeatureEnabled(Environment environment, String featureName) {
        String property = "dw.log." + featureName + ".enabled";
        boolean defaultEnabled = (Boolean)environment.getProperty("dw.log.defaults.enabled", Boolean.class, (Object)false);
        return (Boolean)environment.getProperty(property, Boolean.class, (Object)defaultEnabled);
    }
}

